package com.ozacc.blog.rss.informa;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;

import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.basic.Item;

/**
 * Item󥿡եInformaItemIFҤץ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: ItemAdapter.java,v 1.4.2.1 2004/12/05 05:35:38 otsuka Exp $
 */
public class ItemAdapter implements com.ozacc.blog.rss.Item, Serializable {

	protected Item item;

	public ItemAdapter(ItemIF itemIF) {
		this.item = (Item)itemIF;
	}

	public ItemIF getItemIF() {
		return item;
	}

	/**
	 * @see com.ozacc.blog.rss.Item#getDescription()
	 */
	public String getDescription() {
		return item.getDescription();
	}

	/**
	 * @see com.ozacc.blog.rss.Item#getLink()
	 */
	public URL getLink() {
		return item.getLink();
	}

	/**
	 * @see com.ozacc.blog.rss.Item#getDate()
	 */
	public Date getDate() {
		return item.getDate();
	}

	/**
	 * @see com.ozacc.blog.rss.Item#getTitle()
	 */
	public String getTitle() {
		return item.getTitle();
	}

	/**
	 * @see com.ozacc.blog.rss.Item#getSubject()
	 */
	public String getSubject() {
		return item.getSubject();
	}

	/**
	 * ItemǤϡΥ᥽åɤϥݡȤޤ
	 * 
	 * @throws UnsupportedOperationException
	 * 
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return item.getCreator();
	}

	/**
	 * @see com.ozacc.blog.rss.Item#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		item.setDescription(description);
	}

	/**
	 * @see com.ozacc.blog.rss.Item#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		item.setLink(url);
	}

	/**
	 * @see com.ozacc.blog.rss.Item#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		item.setTitle(title);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		item.setDate(date);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		item.setCreator(creator);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		item.setSubject(subject);
	}

	/**
	 * @see com.ozacc.blog.rss.ContentMetadata#getEncoded()
	 */
	public String getEncoded() {
		return item.getElementValue("content:encoded");
	}

	/**
	 * @see com.ozacc.blog.rss.ContentMetadata#setEncoded(java.lang.String)
	 */
	public void setEncoded(String encoded) {
		// TODO Implement this method.
		throw new UnsupportedOperationException();
	}

}