package com.ozacc.blog.rss.informa;

import java.io.File;
import java.io.IOException;

import org.jdom.Document;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.RSSGenerator;
import com.ozacc.blog.rss.RSSVersion;

import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;

/**
 * InformaChannelExporterѤơRSSϤޤ
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: RSSGeneratorImpl.java,v 1.2.2.2 2004/12/05 05:35:38 otsuka Exp $
 */
public class RSSGeneratorImpl implements RSSGenerator {

	/** ǥեȤʸɡUTF-8ס */
	public static final String DEFAULT_CHARSET = "utf-8";

	private String charset = DEFAULT_CHARSET;

	protected ChannelExporterIF exporter;

	/**
	 * ϥե˻Ѥʸɤ򥻥åȤޤ
	 * 
	 * @param charset ϥե˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * 󥹥ȥ饯
	 */
	public RSSGeneratorImpl() {
		super();
	}

	/**
	 * Ѥʸɤ򥻥åȤ륳󥹥ȥ饯
	 * 
	 * @param charset ϥե˻Ѥʸ
	 */
	public RSSGeneratorImpl(String charset) {
		this();
		this.charset = charset;
	}

	/**
	 * @see com.ozacc.blog.rss.RSSGenerator#newChannel()
	 */
	public Channel newChannel() {
		return new ChannelAdapter(new de.nava.informa.impl.basic.Channel());
	}

	/**
	 * RSS 1.0RSS 2.0ν񤭽Ф򥵥ݡȤƤޤ
	 * 
	 * @see com.ozacc.blog.rss.RSSGenerator#write(com.ozacc.blog.rss.Channel, java.io.File, com.ozacc.blog.rss.RSSVersion)
	 */
	public void write(Channel channel, File file, RSSVersion rssVersion) throws IOException {
		if (rssVersion == RSSVersion.RSS_1_0) {
			exporter = new RSS_1_0_Exporter(file, charset);
		} else if (rssVersion == RSSVersion.RSS_2_0) {
			exporter = new RSS_2_0_Exporter(file, charset);
		}
		// TODO: ǥ㥹ȤǤϤʤpopulate褦ˤС
		ChannelIF c = ((ChannelAdapter)channel).getChannelIF();
		exporter.write(c);
	}

	/**
	 * @see com.ozacc.blog.rss.RSSGenerator#convertIntoJDOMDocument(com.ozacc.blog.rss.Channel, com.ozacc.blog.rss.RSSVersion)
	 */
	public Document convertIntoJDOMDocument(Channel channel, RSSVersion rssVersion) {
		ChannelIF c = ((ChannelAdapter)channel).getChannelIF();
		if (rssVersion == RSSVersion.RSS_1_0) {
			return RSS_1_0_Exporter.getJdomDocument(c);
		} else if (rssVersion == RSSVersion.RSS_2_0) {
			return RSS_2_0_Exporter.getJdomDocument(c);
		}
		throw new IllegalArgumentException("ꤵ줿RSSVersionϤΥ饹ǤϥݡȤƤޤ[" + rssVersion
				+ "]");
	}

}