package com.ozacc.blog.trackback.impl;

import java.net.MalformedURLException;
import java.net.URL;

import com.ozacc.blog.trackback.AsyncTrackBackClient;
import com.ozacc.blog.trackback.TrackBackCallbackHandler;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;

/**
 * AsyncTrackBackClient󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: AsyncTrackBackClientImpl.java,v 1.2.2.2 2004/12/06 05:45:50 otsuka Exp $
 */
public class AsyncTrackBackClientImpl extends TrackBackClientImpl implements AsyncTrackBackClient {

	/**
	 * 󥹥ȥ饯
	 */
	public AsyncTrackBackClientImpl() {
		super();
	}

	/**
	 * 󥹥ȥ饯<br>
	 * Υ饤ȤΥ桼̾򥻥åȤޤ
	 * ͤPing襵ФΥ˻Ĥǽޤ
	 * 
	 * @param userAgent 桼̾
	 */
	public AsyncTrackBackClientImpl(String userAgent) {
		super(userAgent);
	}

	/**
	 * @see com.ozacc.blog.trackback.AsyncTrackBackClient#ping(java.net.URL, com.ozacc.blog.trackback.TrackBackPing, com.ozacc.blog.trackback.TrackBackCallbackHandler)
	 */
	public void ping(final URL trackBackPingUrl, final TrackBackPing ping,
						final TrackBackCallbackHandler handler) {
		Thread t = new Thread() {

			public void run() {
				try {
					ping(trackBackPingUrl, ping);
				} catch (TrackBackException e) {
					handler.handleError(trackBackPingUrl.toString(), ping, e);
					return;
				}
				handler.handleResult(trackBackPingUrl.toString(), ping);
			}
		};
		t.start();
	}

	/**
	 * @see com.ozacc.blog.trackback.AsyncTrackBackClient#ping(java.lang.String, com.ozacc.blog.trackback.TrackBackPing, com.ozacc.blog.trackback.TrackBackCallbackHandler)
	 */
	public void ping(String trackBackPingUrl, TrackBackPing ping, TrackBackCallbackHandler handler) {
		try {
			ping(new URL(trackBackPingUrl), ping, handler);
		} catch (MalformedURLException e) {
			TrackBackException ex = new TrackBackException("ꤵ줿ȥåХåURLǤ[TrackBackURL='"
					+ trackBackPingUrl + "'", e);
			handler.handleError(trackBackPingUrl, ping, ex);
		}
	}

}