package com.ozacc.blog.trackback.impl;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.blog.trackback.TrackBackExtractor;
import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.TrackBackUtils;
import com.ozacc.blog.trackback.support.CharsetResolver;
import com.ozacc.blog.trackback.support.impl.DefaultCharsetResolver;

/**
 * TrackBackExtractor󥿡եμ饹<br>
 * CharsetResolverѤƥȥåХåʸɤ򸡽ФưŪʸɤѴޤ
 * <p>
 * ȥåХåcharsetץѥƥͤåȤƤ硢нϹԤ鷺charsetʸɤѴޤ
 * ޤꤵ줿HttpServletRequestcharacterEncodingåȤƤϡʸɤθСѴϹԤޤ
 * <p>
 * CharsetResolverĤ⥻åȤƤʤȡåȤƤCharsetResolverǤʸɤ򸡽ФǤʤä硢
 * DefaultCharsetResolverѤޤ
 * 
 * @see DefaultCharsetResolver
 * @since 1.2.3
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackExtractorImpl.java,v 1.1.2.3 2004/12/08 19:29:59 otsuka Exp $
 */
public class TrackBackExtractorImpl implements TrackBackExtractor {

	private static Log log = LogFactory.getLog(TrackBackExtractorImpl.class);

	private List charsetResolvers;

	/**
	 * 󥹥ȥ饯
	 */
	public TrackBackExtractorImpl() {
		super();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param charsetResolvers
	 */
	public TrackBackExtractorImpl(List charsetResolvers) {
		this();
		setCharsetResolvers(charsetResolvers);
	}

	/**
	 * CharsetResolver󥹥󥹤List򥻥åȤޤ
	 * Listν֤CharsetResolverƤӽФ졢ǽ˸Ф줿ʸɤŬѤޤ
	 * 
	 * @param charsetResolvers CharsetResolver󥹥󥹤List
	 */
	public void setCharsetResolvers(List charsetResolvers) {
		this.charsetResolvers = charsetResolvers;
	}

	/**
	 * @see com.ozacc.blog.trackback.TrackBackExtractor#getTrackBackPingFromRequest(javax.servlet.http.HttpServletRequest)
	 */
	public TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) {
		if (log.isDebugEnabled()) {
			logReceivedRequest(request);
		}

		String encoding = request.getCharacterEncoding();
		log.debug("characterEncoding='" + encoding + "'");

		TrackBackPing ping = TrackBackUtils.getTrackBackPingFromRequest(request);

		if (isEmpty(encoding)) {
			// charsetåȤƤʤʸɤȽ
			if (isCharsetEmpty(ping)) {
				resolveCharset(ping, request);
			}
			//	ʸѴ
			try {
				ping
						.setExcerpt(TrackBackUtils.convertCharset(ping.getCharset(), ping
								.getExcerpt()));
				ping.setBlogName(TrackBackUtils.convertCharset(ping.getCharset(), ping
						.getBlogName()));
				ping.setTitle(TrackBackUtils.convertCharset(ping.getCharset(), ping.getTitle()));
				ping.setUrl(TrackBackUtils.convertCharset(ping.getCharset(), ping.getUrl()));
			} catch (UnsupportedEncodingException e) {
				// ignore
			}
		} else {
			if (isCharsetEmpty(ping)) {
				ping.setCharset(encoding);
			}
		}

		return ping;
	}

	private boolean isCharsetEmpty(TrackBackPing ping) {
		return ping.getCharset() == null || ping.getCharset().length() == 0;
	}

	private boolean isEmpty(String str) {
		return str == null || str.length() == 0;
	}

	/**
	 * ꤵ줿TrackBackPingHttpServletRequestξ󤫤顢ȥåХå˻ѤƤ
	 * ʸɤ򸡽Фꤵ줿TrackBackPingcharsetץѥƥ˥åȤޤ
	 * 
	 * @param ping 
	 * @param request
	 */
	private void resolveCharset(TrackBackPing ping, HttpServletRequest request) {
		if (charsetResolvers != null) {
			for (Iterator itr = charsetResolvers.iterator(); itr.hasNext();) {
				CharsetResolver resolver = (CharsetResolver)itr.next();
				String charset = resolver.resolveCharset((TrackBackPing)ping.clone(), request);
				if (!isEmpty(charset)) {
					ping.setCharset(charset);
					return;
				}
			}
		}
		CharsetResolver resolver = new DefaultCharsetResolver();
		String charset = resolver.resolveCharset(ping, request);
		ping.setCharset(charset);
	}

	/**
	 * ꥯȤΥإåȥѥ᡼ΰDEBUGϤޤ
	 * 
	 * @param request ꥯ
	 */
	private static void logReceivedRequest(HttpServletRequest request) {
		StringBuffer buf = new StringBuffer();
		buf.append("ꥯȤΥإåȥѥ᡼ΰϤޤ");
		buf.append("----------------------------------------\n");
		buf.append("ꥯȥإå\n");
		buf.append("----------------------------------------\n");
		Enumeration headers = request.getHeaderNames();
		while (headers.hasMoreElements()) {
			String headerName = (String)headers.nextElement();
			String headerValue = request.getHeader(headerName);
			buf.append(headerName).append("='").append(headerValue).append("'\n");
		}
		buf.append("----------------------------------------\n");
		buf.append("ꥯȥѥ᡼\n");
		buf.append("----------------------------------------\n");
		Enumeration params = request.getParameterNames();
		while (params.hasMoreElements()) {
			String paramName = (String)params.nextElement();
			String paramValue = request.getParameter(paramName);
			buf.append(paramName).append("='").append(paramValue).append("'\n");
		}
		buf.append("----------------------------------------\n");
		log.debug(buf.toString());
	}

}