package com.ozacc.blog.ping.impl;

import junit.framework.TestCase;

import com.ozacc.blog.ping.UpdatePingCallbackHandler;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingException;

/**
 * AsyncXmlRpcUpdatePingClientΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: AsyncXmlRpcUpdateClientTest.java,v 1.3.2.2 2004/12/09 14:27:44 otsuka Exp $
 */
public class AsyncXmlRpcUpdateClientTest extends TestCase {

	AsyncXmlRpcUpdatePingClient client;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		client = new AsyncXmlRpcUpdatePingClient();
	}

	/**
	 * @return
	 */
	private UpdatePingCallbackHandler getHandler() {

		return new UpdatePingCallbackHandler() {

			public void handleResult(String message, String pingUrl) {
				// do nothing
			}

			public void handleError(UpdatePingException ex, String pingUrl) {
				System.out.println("URL='" + pingUrl + "', Message='" + ex.getMessage() + "'");
			}
		};

	}

	public void testPingAsyncToWeblogsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		String host = "http://ping.blo.gs";
		UpdatePingCallbackHandler handler = getHandler();

		client.ping(host, blogName, blogUrl, handler);

		Thread.sleep(5 * 1000);
	}

	public void testPingAsyncToMuilpleUrlsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		UpdatePing ping = new UpdatePing(blogName, blogUrl);

		String[] hosts = { "http://ping.blo.gs", "http://ping.myblog.jp/" };
		UpdatePingCallbackHandler handler = getHandler();

		client.ping(hosts, ping, handler);

		Thread.sleep(5 * 1000);
	}
}