package com.ozacc.blog.ping.impl;

import junit.framework.TestCase;

import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.WebServer;

import com.ozacc.blog.ping.FailedUpdatePingException;
import com.ozacc.blog.ping.UpdatePingClient;
import com.ozacc.blog.ping.UpdatePingResponseException;

/**
 * XmlRpcUpdatePingClientΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XmlRpcUpdatePingClientTest.java,v 1.2.2.1 2004/12/09 07:31:45 otsuka Exp $
 */
public class XmlRpcUpdatePingClientTest extends TestCase {

	private UpdatePingClient client;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		client = new XmlRpcUpdatePingClient();
	}

	public void testPingToInvalidServer() throws Exception {
		String blogName = "Example";
		String blogUrl = "http://www.example.com/";

		WebServer server = new WebServer(8080);
		server.addHandler("weblogUpdates", new Echo());
		server.start();
		String host = "http://127.0.0.1:8080";
		try {
			String message = client.ping(host, blogName, blogUrl);
			fail("UpdatePingException should have been called.");
		} catch (UpdatePingResponseException expected) {
			assertEquals("бƤʤեޥåȤΥ쥹ݥ󥹤֤ޤ", expected.getMessage());
		} finally {
			server.shutdown();
		}
	}

	/**
	 * http://ping.blo.gs Υ쥹ݥ󥹡
	 * {message=Succeeded., flerror=false}
	 * 
	 * http://rpc.weblogs.com/RPC2 Υ쥹ݥ
	 * {message=Thanks for the ping., flerror=false}
	 */
	public void testPingToWeblogsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		String host = "http://ping.blo.gs";
		try {
			String message = client.ping(host, blogName, blogUrl);
			fail("UpdatePingException should have been called.");
		} catch (FailedUpdatePingException e) {
			System.out.println("Message [" + e.getMessage() + "]");
		}
	}
}