package com.ozacc.blog.trackback.impl;

import junit.framework.TestCase;

import com.ozacc.blog.trackback.TrackBackCallbackHandler;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: AsyncTrackBackClientImplTest.java,v 1.1.2.1 2004/12/09 14:27:44 otsuka Exp $
 */
public class AsyncTrackBackClientImplTest extends TestCase {

	private AsyncTrackBackClientImpl client;

	private TrackBackPing ping;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		client = new AsyncTrackBackClientImpl("trackback client");

		ping = new TrackBackPing();
		ping.setTitle("AsyncTrackBackClientImplƥȥ");
		ping.setExcerpt("AsyncTrackBackClientImplƥȥΥȥåХå");
		ping.setUrl("http://www.example.com");
		ping.setBlogName("AsyncTrackBack Client Test");
	}

	/*
	 * Class under test for void ping(String, TrackBackPing, TrackBackCallbackHandler)
	 */
	public final void testPingStringTrackBackPingTrackBackCallbackHandler() throws Exception {
		String pingUrl = "http://spring-ext.sourceforge.jp/cgi-bin/mt-tb.cgi/2";

		TrackBackCallbackHandler handler = new TrackBackCallbackHandler() {

			public void handleResult(String trackBackPingUrl, TrackBackPing ping) {
				System.out.println("TrackBackPing was sent successfully to '" + trackBackPingUrl
						+ "'");
			}

			public void handleError(String trackBackPingUrl, TrackBackPing ping,
									TrackBackException ex) {
				fail("This should never be called.");
			}
		};

		client.ping(pingUrl, ping, handler);

		Thread.sleep(5000);
	}

	public final void testPingStringTrackBackPingTrackBackCallbackHandlerFail() throws Exception {
		String pingUrl = "http://spring-ext.sourceforge.jp/cgi-bin/mt-tb.cgi/0";

		TrackBackCallbackHandler handler = new TrackBackCallbackHandler() {

			public void handleResult(String trackBackPingUrl, TrackBackPing ping) {
				fail("This should never be called.");
			}

			public void handleError(String trackBackPingUrl, TrackBackPing ping,
									TrackBackException ex) {
				System.out.println(ex.getMessage());
			}
		};

		client.ping(pingUrl, ping, handler);

		Thread.sleep(5000);
	}
}