package com.ozacc.blog.trackback.impl;

import java.net.URL;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;

/**
 * TrackBackClientImplΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackClientImplTest.java,v 1.2.2.2 2004/12/09 07:23:52 otsuka Exp $
 */
public class TrackBackClientImplTest extends TestCase {

	private TrackBackClientImpl client;

	private TrackBackPing ping;

	private String pingUrl = "http://www.example.com/trackback";

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();

		client = new TrackBackClientImpl("trackback client");
		//client.setCharset("EUC-JP");

		ping = new TrackBackPing();
		ping.setTitle("TrackBackClientImplƥȥ");
		ping.setExcerpt("TrackBackClientImplƥȥΥȥåХå");
		ping.setUrl("http://www.example.com");
		ping.setBlogName("TrackBack Client Test");
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public final void testSendTrackBackPing() throws Exception {
		try {
			client.ping(pingUrl, ping);
		} catch (TrackBackException e) {
			e.printStackTrace();
			throw e;
		}
	}

	public final void testSendTrackBackPingToIllegalURL() throws Exception {
		URL url = new URL("http://www.google.co.jp/");
		ping.setUrl(null);
		try {
			client.ping(url, ping);
			fail("TrackBackException should have been called.");
		} catch (TrackBackException expected) {
			// success
		}
	}

	public final void testSendTrackBackPingWithNullURL() throws Exception {
		ping.setUrl(null);
		try {
			client.ping(pingUrl, ping);
			fail("TrackBackException should have been called.");
		} catch (TrackBackException expected) {
			// success
		}
	}

}