package com.ozacc.blog.rss;

import java.net.URL;

/**
 * RSSѡ
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: RSSParser.java,v 1.4.2.3 2004/12/08 19:29:59 otsuka Exp $
 */
public interface RSSParser {

	/**
	 * ꤵ줿URLRSS XMLϤChannel֥Ȥޤ
	 * 
	 * @param rssUrl RSSXMLե򼨤URL
	 * @return RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 */
	Channel parseRSS(URL rssUrl) throws ParseException;

	/**
	 * ꤵ줿URLRSS XMLϤChannel֥Ȥޤ
	 * 
	 * @param rssUrl RSSXMLե򼨤URL
	 * @return RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 */
	Channel parseRSS(String rssUrl) throws ParseException;

	/**
	 * Basicǧڤǥ¤ƤURLRSS XMLϤChannel֥Ȥޤ
	 * 
	 * @since 1.2.3
	 * 
	 * @param rssUrl RSSXMLե򼨤URL
	 * @param userName ǧڥ桼̾
	 * @param password ǧڥѥ
	 * @return RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 */
	Channel parseRSS(URL rssUrl, String userName, String password) throws ParseException;

	/**
	 * Basicǧڤǥ¤ƤURLRSS XMLϤChannel֥Ȥޤ
	 * 
	 * @since 1.2.3
	 * 
	 * @param rssUrl RSSXMLե򼨤URL
	 * @param userName ǧڥ桼̾
	 * @param password ǧڥѥ
	 * @return RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 */
	Channel parseRSS(String rssUrl, String userName, String password) throws ParseException;

	/**
	 * ꤵ줿URLWebڡޤ줿RSS URLõФ
	 * URLRSS XMLϤơChannel֥Ȥޤ<br>
	 * ʣRSS URLĤäϡֺǽ˸ĤäURLμRSSоݤˤʤޤ
	 * 
	 * @param targetPageUrl
	 * @return Channel RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 *
	 * @see RSSAutoDiscovery
	 */
	Channel discoverAndParseRSS(URL targetPageUrl) throws ParseException;

	/**
	 * ꤵ줿URLWebڡޤ줿RSS URLõФ
	 * URLRSS XMLϤơChannel֥Ȥޤ<br>
	 * ʣRSS URLĤäϡֺǽ˸ĤäURLμRSSоݤˤʤޤ
	 * 
	 * @param targetPageUrl
	 * @return Channel RSS򼨤Channel󥹥
	 * @throws ParseException RSSμޤϥѡ˼Ԥ
	 *
	 * @see RSSAutoDiscovery
	 */
	Channel discoverAndParseRSS(String targetPageUrl) throws ParseException;

}