package com.ozacc.blog.rss.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.HttpConnection.ConnectionTimeoutException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.ParseTimeoutException;
import com.ozacc.blog.rss.RSSAutoDiscovery;
import com.ozacc.blog.rss.RSSParser;
import com.ozacc.blog.rss.support.XmlInputStreamParser;
import com.ozacc.blog.util.CommonsHttpClientUtils;

/**
 * RSSXMLϤ<code>XmlInputStreamParser</code>˰ѾRSSParser饹
 * 
 * @see XmlInputStreamParser
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: RSSParserImpl.java,v 1.5.2.4 2004/12/09 14:28:22 otsuka Exp $
 */
public class RSSParserImpl implements RSSParser {

	/** ǥեȤ³ॢȻ֡5,000ߥá*/
	public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	/** ǥեȤɹॢȻ֡5,000ߥá*/
	public static final int DEFAULT_READ_TIMEOUT = 5000;

	private static Log log = LogFactory.getLog(RSSParserImpl.class);

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	private boolean followRedirect = true;

	private RSSAutoDiscovery rssAutoDiscovery;

	private XmlInputStreamParser xmlInputStreamParser;

	/**
	 * 󥹥ȥ饯
	 */
	public RSSParserImpl() {
		super();
		initRSSAutoDiscovery();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param xmlInputStreamParser XmlInputStreamParserμ󥹥
	 */
	public RSSParserImpl(XmlInputStreamParser xmlInputStreamParser) {
		this();
		setXmlInputStreamParser(xmlInputStreamParser);
	}

	private void initRSSAutoDiscovery() {
		rssAutoDiscovery = new RSSAutoDiscoveryImpl();
	}

	/**
	 * ³ॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ<br>
	 * 0򥻥åȤ̵¤ˤʤޤ
	 * 
	 * @param connectionTimeout ³ॢ (ms)
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * ³ɹॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ<br>
	 * 0򥻥åȤ̵¤ˤʤޤ
	 * 
	 * @param timeout ɹॢ (ms)
	 */
	public void setReadTimeout(int timeout) {
		this.readTimeout = timeout;
	}

	/**
	 * XmlInputStreamParserμ󥹥󥹤򥻥åȤޤ
	 * 
	 * @param xmlInputStreamParser XmlInputStreamParserμ󥹥
	 */
	public void setXmlInputStreamParser(XmlInputStreamParser xmlInputStreamParser) {
		this.xmlInputStreamParser = xmlInputStreamParser;
	}

	/**
	 * @see com.ozacc.blog.rss.RSSParser#parseRSS(java.net.URL)
	 */
	public Channel parseRSS(URL rssUrl) throws ParseException {
		return parseRSS(rssUrl.toString());
	}

	/**
	 * @see com.ozacc.blog.rss.RSSParser#parseRSS(java.lang.String)
	 */
	public Channel parseRSS(String url) throws ParseException {
		return parseRSS(url, null, null);
	}

	private Channel parseXmlInputStream(InputStream is) throws ParseException {
		log.debug("RSSѡޤ");
		return xmlInputStreamParser.parseXmlInputStream(is);
	}

	/**
	 * @see com.ozacc.blog.rss.RSSParser#discoverAndParseRSS(java.net.URL)
	 */
	public Channel discoverAndParseRSS(URL targetPageUrl) throws ParseException {
		URL[] rssUrls;
		try {
			rssUrls = rssAutoDiscovery.discoverRSSUrls(targetPageUrl);
		} catch (ParseException e) {
			throw new ParseException("RSSAutoDiscovery˼Ԥޤ[url='" + targetPageUrl + "']", e);
		}
		if (rssUrls.length > 0) {
			return parseRSS(rssUrls[0]);
		}
		throw new ParseException("ꤵ줿URLΥڡǤRSSURL򸫤ĤޤǤ[url='" + targetPageUrl + "']");
	}

	/**
	 * @see com.ozacc.blog.rss.RSSParser#discoverAndParseRSS(java.lang.String)
	 */
	public Channel discoverAndParseRSS(String targetPageUrl) throws ParseException {
		try {
			return discoverAndParseRSS(new URL(targetPageUrl));
		} catch (MalformedURLException e) {
			throw new ParseException("ꤵ줿URLΥեޥåȤǤ[url='" + targetPageUrl + "']", e);
		}
	}

	/**
	 * @since 1.2.3
	 * @see com.ozacc.blog.rss.RSSParser#parseRSS(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Channel parseRSS(String url, String userName, String password) throws ParseException {
		if (xmlInputStreamParser == null) {
			throw new IllegalStateException("XMLInputStreamParseråȤƤޤ");
		}

		HttpClient client = new HttpClient();
		log.debug("³ॢȤꤷޤ[" + connectionTimeout + "]");
		client.setConnectionTimeout(connectionTimeout);
		log.debug("ɹॢȤꤷޤ[" + readTimeout + "]");
		client.setTimeout(readTimeout);

		HttpMethod method = new GetMethod(url);
		method.setFollowRedirects(followRedirect);
		if (userName != null) {
			log.debug("ǧھꤷޤ[userName='" + userName + "', password='" + password + "']");
			HttpState state = client.getState();
			Credentials credentials = new UsernamePasswordCredentials(userName, password);
			state.setCredentials(null, null, credentials);
		}
		try {
			log.debug("HTTP³Ԥޤ[" + url + "]");
			int statusCode = client.executeMethod(method);
			if (!CommonsHttpClientUtils.isSuccessfulResponse(statusCode, followRedirect)) {
				throw new ParseException("HTTP³ǤޤǤ[HTTP_STATUS='"
						+ HttpStatus.getStatusText(statusCode) + "', rssUrl='" + url + "']");
			}
			InputStream is = method.getResponseBodyAsStream();
			return parseXmlInputStream(is);
		} catch (ConnectionTimeoutException e) {
			throw new ParseTimeoutException("HTTP³ॢȡ[rssUrl='" + url + "']", e);
		} catch (HttpRecoverableException e) {
			throw new ParseTimeoutException("HTTPɹॢȡ[rssUrl='" + url + "']", e);
		} catch (ParseException e) {
			throw new ParseException("RSSΥѡ˼Ԥޤ[rssUrl='" + url + "']", e);
		} catch (IOException e) {
			throw new ParseException("ꤵ줿URLRSS˼Ԥޤ[rssUrl='" + url + "']", e);
		} finally {
			method.releaseConnection();
		}
	}

	/**
	 * @since 1.2.3
	 * @see com.ozacc.blog.rss.RSSParser#parseRSS(java.net.URL, java.lang.String, java.lang.String)
	 */
	public Channel parseRSS(URL url, String userName, String password) throws ParseException {
		return parseRSS(url.toString(), userName, password);
	}

	/**
	 * URL쥯ȥ쥹ݥ(HTTP Status Code 3xx)֤Ƥˡ
	 * 쥯˥뤫ɤꤷޤǥեȤǤϡ쥯˥ޤ
	 * 
	 * @since 1.2.4
	 * @param followRedirect 쥯˥ trueǥեȤtrue
	 */
	public void setFollowRedirect(boolean followRedirect) {
		this.followRedirect = followRedirect;
	}
}