package com.ozacc.blog.rss.informa;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.Item;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;

/**
 * Channel󥿡եInformaChannelIF󥿡եȤΥץ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: ChannelAdapter.java,v 1.5.2.2 2004/12/05 05:35:38 otsuka Exp $
 */
public class ChannelAdapter implements Channel, Serializable {

	protected ChannelIF channel;

	public ChannelAdapter(ChannelIF channel) {
		this.channel = channel;
	}

	public ChannelIF getChannelIF() {
		return channel;
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getItems()
	 */
	public Item[] getItems() {
		Collection items = channel.getItems();
		Iterator itr = items.iterator();
		List itemList = new ArrayList();
		while (itr.hasNext()) {
			ItemIF i = (ItemIF)itr.next();
			Item item = new ItemAdapter(i);
			itemList.add(item);
		}
		return (Item[])itemList.toArray(new Item[itemList.size()]);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getTitle()
	 */
	public String getTitle() {
		return channel.getTitle();
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getLink()
	 */
	public URL getLink() {
		return channel.getSite();
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#getDescription()
	 */
	public String getDescription() {
		return channel.getDescription();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return channel.getLanguage();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return channel.getPubDate();
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return channel.getCreator();
	}

	/**
	 * ChannelǤϡΥ᥽åɤϥݡȤޤ
	 * 
	 * @throws UnsupportedOperationException
	 * 
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		throw new UnsupportedOperationException();
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#newItem()
	 */
	public Item newItem() {
		de.nava.informa.impl.basic.Item item = new de.nava.informa.impl.basic.Item();
		item.setChannel(this.channel);
		return new ItemAdapter(item);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#addItem(com.ozacc.blog.rss.Item)
	 */
	public void addItem(Item item) {
		ItemIF i = ((ItemAdapter)item).getItemIF();
		channel.addItem(i);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		channel.setTitle(title);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		channel.setSite(url);
	}

	/**
	 * @see com.ozacc.blog.rss.Channel#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		channel.setDescription(description);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		channel.setLanguage(language);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		channel.setLastUpdated(date);
	}

	/**
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		channel.setCreator(creator);
	}

	/**
	 * ChannelǤϡΥ᥽åɤϥݡȤޤ
	 * 
	 * @throws UnsupportedOperationException
	 * 
	 * @see com.ozacc.blog.rss.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		throw new UnsupportedOperationException();
	}

}