package com.ozacc.blog.trackback.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.HttpConnection.ConnectionTimeoutException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ozacc.blog.trackback.ConnectionException;
import com.ozacc.blog.trackback.FailedTrackBackException;
import com.ozacc.blog.trackback.TrackBackClient;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.TrackBackResponseException;
import com.ozacc.blog.util.CommonsHttpClientUtils;

/**
 * TrackBackClient󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackClientImpl.java,v 1.5.2.3 2004/12/09 14:28:22 otsuka Exp $
 */
public class TrackBackClientImpl implements TrackBackClient {

	public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	public static final int DEFAULT_READ_TIMEOUT = 5000;

	/** ǥեȤʸɡUTF-8ס */
	public static final String DEFAULT_CHARSET = "utf-8";

	private static Log log = LogFactory.getLog(TrackBackClientImpl.class);

	private String userAgent;

	private String charset = DEFAULT_CHARSET;

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	/**
	 * 󥹥ȥ饯
	 */
	public TrackBackClientImpl() {}

	/**
	 * 󥹥ȥ饯<br>
	 * Υ饤ȤΥ桼̾򥻥åȤޤ
	 * ͤPing襵ФΥ˻Ĥǽޤ
	 * 
	 * @param userAgent 桼̾
	 */
	public TrackBackClientImpl(String userAgent) {
		setUserAgent(userAgent);
	}

	/**
	 * TrackBackClientΥ桼̾
	 * 
	 * @return ȥåХå饤ȤΥ桼̾
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * ȥåХåǡΥ󥳡ɤ˻Ѥʸɤ֤ޤ
	 * 
	 * @return ȥåХåǡΥ󥳡ɤ˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ȥåХåǡΥ󥳡ɤ˻Ѥʸɤꤷޤ
	 * ǥեȤUTF-8ǤۤȤɤBlogӥǤϡUTF-8ɸȤƤޤΤǡǥեȤѹʤȤ侩ޤ
	 * 
	 * @param charset ȥåХåǡΥ󥳡ɤ˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * TrackBackClientΥ桼̾ꤷޤ
	 * ꤷʤϡȥåХå Ping ǡ˴ޤޤ blog_name ͤѤޤ
	 * 
	 * @param userAgent TrackBackClientΥ桼̾
	 */
	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	/**
	 * @see com.ozacc.blog.trackback.TrackBackClient#ping(java.net.URL, com.ozacc.blog.trackback.TrackBackPing)
	 */
	public void ping(URL trackBackPingUrl, TrackBackPing ping) throws TrackBackException {
		ping(trackBackPingUrl.toString(), ping);
	}

	/**
	 * @see com.ozacc.blog.trackback.TrackBackClient#ping(java.lang.String, com.ozacc.blog.trackback.TrackBackPing)
	 */
	public void ping(String trackBackPingUrl, TrackBackPing ping) throws TrackBackException {
		HttpClient client = new HttpClient();
		log.debug("³ॢȤꤷޤ[" + connectionTimeout + "]");
		client.setConnectionTimeout(connectionTimeout);
		log.debug("ɹॢȤꤷޤ[" + readTimeout + "]");
		client.setTimeout(readTimeout);

		// Ѥʸɤ
		String appliedCharset = null;
		if (ping.getCharset() != null && ping.getCharset().length() > 0) {
			appliedCharset = ping.getCharset();
		} else {
			appliedCharset = charset;
		}

		PostMethod post = new PostMethod(trackBackPingUrl);
		NameValuePair[] data = buildPostData(ping);
		post.setRequestBody(data);
		post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset="
				+ appliedCharset);
		// User-AgentΥå
		if (userAgent != null) {
			post.setRequestHeader("User-Agent", userAgent);
		}

		try {
			int statusCode = client.executeMethod(post);
			if (!CommonsHttpClientUtils.isSuccessfulResponse(statusCode, false)) {
				throw new ConnectionException("ꤵ줿TrackBack URLHTTP³ǤޤǤ[HTTP_STATUS='"
						+ HttpStatus.getStatusText(statusCode) + "', TrackBackURL='"
						+ trackBackPingUrl + "']");
			}
			InputStream is = post.getResponseBodyAsStream();
			String message = parseResponseStream(is);
			if (message != null) {
				throw new FailedTrackBackException(message);
			}
			is.close();
		} catch (ConnectionTimeoutException e) {
			throw new com.ozacc.blog.trackback.ConnectionTimeoutException(
					"HTTP³ॢȡ[TrackBackURL='" + trackBackPingUrl + "']", e);
		} catch (HttpRecoverableException e) {
			throw new com.ozacc.blog.trackback.ConnectionTimeoutException(
					"HTTPɹॢȡ[TrackBackURL='" + trackBackPingUrl + "']", e);
		} catch (IOException e) {
			throw new ConnectionException("ȥåХå˼Ԥޤ[TrackBackURL='" + trackBackPingUrl
					+ "']", e);
		} finally {
			post.releaseConnection();
		}
	}

	/**
	 * ꤵ줿ȥåХåPingCommons-HttpClientѤNaveValuePair[]Ѵޤ
	 * 
	 * @param ping ȥåХåPing
	 * @return ȥåХåPingǡ򼨤NaveValuePair[]
	 */
	private NameValuePair[] buildPostData(TrackBackPing ping) {
		List list = new ArrayList();

		// charset
		if (charset != null && charset.length() > 0) {
			list.add(new NameValuePair("charset", charset.toLowerCase()));
		}

		if (ping.getTitle() != null) {
			list.add(new NameValuePair("title", ping.getTitle()));
		}
		if (ping.getUrl() != null) {
			list.add(new NameValuePair("url", ping.getUrl()));
		}
		if (ping.getExcerpt() != null) {
			list.add(new NameValuePair("excerpt", ping.getExcerpt()));
		}
		if (ping.getBlogName() != null) {
			list.add(new NameValuePair("blog_name", ping.getBlogName()));
		}
		return (NameValuePair[])list.toArray(new NameValuePair[list.size()]);
	}

	/**
	 * @param is
	 * @return
	 * @throws TrackBackResponseException
	 * @throws FactoryConfigurationError
	 * @throws SAXException
	 * @throws IOException
	 * @throws ParserConfigurationException 
	 */
	private String parseResponseStream(InputStream is) throws TrackBackResponseException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setIgnoringElementContentWhitespace(true);
			factory.setIgnoringComments(true);
			Document doc = factory.newDocumentBuilder().parse(is);

			NodeList errorList = doc.getElementsByTagName("error");
			Node errorNode = errorList.item(0);
			String errorCode = errorNode.getFirstChild().getNodeValue();
			if ("0".equals(errorCode)) {
				return null;
			}

			NodeList msgList = doc.getElementsByTagName("message");
			Node msgNode = msgList.item(0);
			String message = msgNode.getFirstChild().getNodeValue();
			return message;
		} catch (Exception ex) {
			throw new TrackBackResponseException("Х쥹ݥ󥹤μ˼Ԥޤ", ex);
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					// ignore
				}
			}
		}
	}

	/**
	 * ³ॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param connectionTimeout ³ॢ (ms)
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * ³ɹॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param timeout ɹॢ (ms)
	 */
	public void setReadTimeout(int timeout) {
		this.readTimeout = timeout;
	}
}