package com.ozacc.blog.rss.impl;

import java.net.URL;

import junit.framework.TestCase;

import com.ozacc.blog.rss.ParseException;

/**
 * RSSAutoDiscoveryImplΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: RSSAutoDiscoveryImplTest.java,v 1.2.2.2 2004/12/09 14:27:44 otsuka Exp $
 */
public class RSSAutoDiscoveryImplTest extends TestCase {

	private RSSAutoDiscoveryImpl autoDiscovery;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		autoDiscovery = new RSSAutoDiscoveryImpl();
	}

	public final void testDiscoverRSSUrls() throws Exception {
		URL url = new URL("http://spring-ext.sourceforge.jp/blog/");
		URL[] result = autoDiscovery.discoverRSSUrls(url);

		assertEquals(2, result.length);

		URL rssUrl = result[0];
		assertEquals("http://spring-ext.sourceforge.jp/blog/index.rdf", rssUrl.toString());

		rssUrl = result[1];
		assertEquals("http://spring-ext.sourceforge.jp/blog/index.xml", rssUrl.toString());
	}

	public final void testDiscoverRSSUrlsNone() throws Exception {
		URL url = new URL("http://www.google.co.jp/");
		URL[] result = autoDiscovery.discoverRSSUrls(url);

		assertEquals(0, result.length);
	}

	public final void testDiscoverRSSUrlsInvalidUrl() throws Exception {
		URL url = new URL("http://spring-ext.sourceforge.jp/blog/index100.html");
		try {
			URL[] result = autoDiscovery.discoverRSSUrls(url);
			fail("ParseException should have been called.");
		} catch (ParseException expected) {
			// success	
		}
	}

	public final void testDiscoverRSSUrls2() throws Exception {
		URL url = new URL("http://shi3z.exblog.jp/");
		URL[] result = autoDiscovery.discoverRSSUrls(url);

		assertEquals(1, result.length);

		URL rssUrl = result[0];
		System.out.println(rssUrl);
		assertEquals("http://shi3z.exblog.jp/index.xml", rssUrl.toString());
	}

}