package com.ozacc.blog.trackback;

import junit.framework.TestCase;

import com.mockobjects.servlet.MockHttpServletRequest;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackUtilsTest.java,v 1.4 2004/11/29 19:10:21 otsuka Exp $
 */
public class TrackBackUtilsTest extends TestCase {

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	public void testRequestToTrackBackPing() throws Exception {
		String blogName = "ƥѥ֥";
		String url = "http://www.example.com/test.html";
		String excerpt = "ȥ꡼";
		String title = "ƥȥȥ꡼";

		MockHttpServletRequest request = new MockHttpServletRequest();
		request.setupAddParameter("blog_name", blogName);
		request.setupAddParameter("url", url);
		request.setupAddParameter("excerpt", excerpt);
		request.setupAddParameter("title", title);
		request.setupAddParameter("charset", "utf-8");

		TrackBackPing ping = TrackBackUtils.getTrackBackPingFromRequest(request);

		assertEquals(blogName, ping.getBlogName());
		assertEquals(url, ping.getUrl());
		assertEquals(excerpt, ping.getExcerpt());
		assertEquals(title, ping.getTitle());

		request.verify();
	}

	public void testGetSuccessfulResponse() throws Exception {
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		buf.append("<response>\n");
		buf.append("<error>0</error>\n");
		buf.append("</response>");
		String expected = buf.toString();

		String res = TrackBackUtils.getSuccessResponse();

		assertEquals(expected, res);
	}

	public void testGetErrorResponse() throws Exception {
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		buf.append("<response>\n");
		buf.append("<error>1</error>\n");
		buf.append("<message>URLåȤƤޤ</message>\n");
		buf.append("</response>");
		String expected = buf.toString();

		String res = TrackBackUtils.getErrorResponse("URLåȤƤޤ");

		assertEquals(expected, res);
	}

	public void testIsRSSMode() throws Exception {
		MockHttpServletRequest request = new MockHttpServletRequest();
		request.setupGetMethod("GET");
		request.setupAddParameter("__mode", "rss");

		boolean result = TrackBackUtils.isRSSMode(request);
		assertTrue(result);
	}

	public void testIsRSSModePost() throws Exception {
		MockHttpServletRequest request = new MockHttpServletRequest();
		request.setupGetMethod("POST");
		request.setupPathInfo("__mode=rss");

		boolean result = TrackBackUtils.isRSSMode(request);
		assertFalse(result);
	}
}