/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.support.impl;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.Item;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.impl.ChannelAdapter;
import com.ozacc.blog.rss.support.XmlInputStreamParser;
import com.ozacc.blog.util.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMXmlInputStreamParserImpl
implements XmlInputStreamParser {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.rss.support.impl.DOMXmlInputStreamParserImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Channel parseXmlInputStream(InputStream is) throws ParseException {
        try {
            Document doc = this.getDocument(is);
            return this.parseXml(doc);
        }
        catch (Exception e) {
            throw new ParseException("RSS XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Channel parseXml(Document doc) {
        Node root = doc.getFirstChild();
        ChannelAdapter c = new ChannelAdapter();
        Node channel = doc.getElementsByTagName("channel").item(0);
        this.parseChannel(c, channel);
        NodeList items = doc.getElementsByTagName("item");
        this.parseItems(c, items);
        return c;
    }

    private void parseItems(ChannelAdapter c, NodeList items) {
        int i = 0;
        while (i < items.getLength()) {
            Node itemNode = items.item(i);
            log.debug((Object)itemNode.getNodeName());
            Item item = c.newItem();
            if (this.isNodeName(itemNode, "title")) {
                item.setTitle(this.retrieveNodeValue(itemNode));
            } else if (this.isNodeName(itemNode, "link")) {
                try {
                    item.setLink(new URL(this.retrieveNodeValue(itemNode)));
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (this.isNodeName(itemNode, "dc:description")) {
                item.setDescription(this.retrieveNodeValue(itemNode));
            } else if (this.isNodeName(itemNode, "dc:date")) {
                String d = this.retrieveNodeValue(itemNode);
                try {
                    item.setDate(DateFormat.parse(d));
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
            } else if (this.isNodeName(itemNode, "dc:creator")) {
                item.setCreator(this.retrieveNodeValue(itemNode));
            } else if (this.isNodeName(itemNode, "dc:subject")) {
                item.setSubject(this.retrieveNodeValue(itemNode));
            } else {
                c.addItem(item);
            }
            ++i;
        }
    }

    private void parseChannel(ChannelAdapter c, Node channel) {
        NodeList channelChildren = channel.getChildNodes();
        int i = 0;
        while (i < channelChildren.getLength()) {
            Node channelChildNode = channelChildren.item(i);
            log.debug((Object)channelChildNode.getNodeName());
            if (this.isNodeName(channelChildNode, "title")) {
                c.setTitle(this.retrieveNodeValue(channelChildNode));
            } else if (this.isNodeName(channelChildNode, "link")) {
                try {
                    c.setLink(new URL(this.retrieveNodeValue(channelChildNode)));
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (this.isNodeName(channelChildNode, "description")) {
                c.setDescription(this.retrieveNodeValue(channelChildNode));
            } else if (this.isNodeName(channelChildNode, "dc:date")) {
                String d = this.retrieveNodeValue(channelChildNode);
                try {
                    c.setDate(DateFormat.parse(d));
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
            } else if (this.isNodeName(channelChildNode, "dc:creator")) {
                c.setCreator(this.retrieveNodeValue(channelChildNode));
            } else if (this.isNodeName(channelChildNode, "dc:language")) {
                c.setLanguage(this.retrieveNodeValue(channelChildNode));
            }
            ++i;
        }
    }

    private boolean isNodeName(Node channelChildNode, String name) {
        return name.equals(channelChildNode.getNodeName());
    }

    private String retrieveNodeValue(Node n) {
        Node valueNode = n.getFirstChild();
        if (valueNode != null) {
            return valueNode.getNodeValue();
        }
        return null;
    }

    private Document getDocument(InputStream is) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(is);
    }
}

