/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch;

import com.ozacc.mail.Mail;
import java.util.Date;
import java.util.Iterator;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class ReceivedMail
extends Mail {
    private Date date;
    private String messageId;
    private int size;
    private MimeMessage message;

    public ReceivedMail() {
    }

    public ReceivedMail(String charset) {
        super(charset);
    }

    public ReceivedMail(Mail original) {
        super(original);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getMessageIdOnly() {
        return this.messageId.substring(1, this.messageId.length() - 1);
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("Mail\n");
        buf.append("Return-Path: ").append(this.returnPath).append("\n");
        buf.append("Message-ID: ").append(this.messageId).append("\n");
        buf.append("Date: ").append(this.date).append("\n");
        buf.append("From: ").append(this.from != null ? this.from.toUnicodeString() : null).append("\n");
        buf.append("To: ").append(this.arrayToCommaDelimitedString(this.to)).append("\n");
        buf.append("Cc: ").append(this.arrayToCommaDelimitedString(this.cc)).append("\n");
        buf.append("Bcc: ").append(this.arrayToCommaDelimitedString(this.bcc)).append("\n");
        buf.append("Reply-To: ").append(this.replyTo != null ? this.replyTo.toUnicodeString() : null).append("\n");
        buf.append("Subject: ").append(this.subject).append("\n");
        if (this.xHeaders != null) {
            Iterator itr = this.xHeaders.keySet().iterator();
            while (itr.hasNext()) {
                String header = (String)itr.next();
                String value = (String)this.xHeaders.get(header);
                buf.append(header).append(": ").append(value).append("\n");
            }
        }
        buf.append("\n");
        buf.append(this.text);
        if (this.htmlText != null) {
            buf.append("\n\n-----\n\n");
            buf.append(this.htmlText);
        }
        if (this.isFileAttached()) {
            buf.append("\n\nAttachments\n");
            int i = 0;
            int num = this.attachmentFiles.size();
            while (i < num) {
                Mail.AttachmentFile f = (Mail.AttachmentFile)this.attachmentFiles.get(i);
                buf.append("[").append(i).append("] ").append(f.getName()).append("\n");
                ++i;
            }
        }
        return buf.toString();
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    public boolean setDelete(boolean delete) {
        if (this.message != null) {
            try {
                this.message.setFlag(Flags.Flag.DELETED, delete);
            }
            catch (MessagingException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

