/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.UnknownCharacterException;

public class ByteToCharUTF7
extends ByteToCharConverter {
    private boolean b64Context = false;
    private int currentB64Off = 0;
    private char currentChar = '\u0000';

    public String getCharacterEncoding() {
        return "UTF7";
    }

    public int flush(char[] chars, int off, int len) {
        this.byteOff = 0;
        this.charOff = 0;
        this.b64Context = false;
        this.currentB64Off = 0;
        this.currentChar = '\u0000';
        return 0;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.b64Context = false;
        this.currentB64Off = 0;
        this.currentChar = '\u0000';
    }

    public int convert(byte[] bytes, int byteStart, int byteEnd, char[] chars, int charStart, int charEnd) throws ConversionBufferFullException, UnknownCharacterException {
        this.charOff = charStart;
        this.byteOff = byteStart;
        while (this.byteOff < byteEnd) {
            if (this.charOff >= charEnd) {
                throw new ConversionBufferFullException();
            }
            if (this.b64Context) {
                if (bytes[this.byteOff] == 45) {
                    if (this.currentB64Off != 0 && this.currentChar > '\u0000') {
                        chars[this.charOff] = this.currentChar;
                        ++this.charOff;
                    }
                    this.b64Context = false;
                } else {
                    int part = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(bytes[this.byteOff]);
                    if (part == -1) {
                        throw new UnknownCharacterException("Invalid UTF-7 code: " + (char)bytes[this.byteOff]);
                    }
                    switch (this.currentB64Off) {
                        case 0: {
                            this.currentChar = (char)(part << 10);
                            break;
                        }
                        case 1: {
                            this.currentChar = (char)(this.currentChar | (char)(part << 4));
                            break;
                        }
                        case 2: {
                            chars[this.charOff] = this.currentChar = (char)(this.currentChar | (char)(part >> 2));
                            ++this.charOff;
                            this.currentChar = (char)((part & 3) << 14);
                            break;
                        }
                        case 3: {
                            this.currentChar = (char)(this.currentChar | (char)(part << 8));
                            break;
                        }
                        case 4: {
                            this.currentChar = (char)(this.currentChar | (char)(part << 2));
                            break;
                        }
                        case 5: {
                            chars[this.charOff] = this.currentChar = (char)(this.currentChar | (char)(part >> 4));
                            ++this.charOff;
                            this.currentChar = (char)((part & 0xF) << 12);
                            break;
                        }
                        case 6: {
                            this.currentChar = (char)(this.currentChar | (char)(part << 6));
                            break;
                        }
                        case 7: {
                            chars[this.charOff] = this.currentChar = (char)(this.currentChar | (char)part);
                            ++this.charOff;
                        }
                    }
                    this.currentB64Off = (this.currentB64Off + 1) % 8;
                }
            } else if (bytes[this.byteOff] == 43) {
                this.b64Context = true;
                this.currentB64Off = 0;
            } else {
                chars[this.charOff] = (char)bytes[this.byteOff];
                ++this.charOff;
            }
            ++this.byteOff;
        }
        return this.charOff - charStart;
    }
}

