package com.ozacc.mail;

import java.io.File;

import org.apache.velocity.VelocityContext;

/**
 * VelocityϢȤưŪ˥᡼ǡΥǡMail󥹥󥹤륤󥿡ե
 * 
 * @see com.ozacc.mail.impl.XMLVelocityMailBuilderImpl
 * @see com.ozacc.mail.impl.JDomXMLMailBuilder
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: VelocityMailBuilder.java,v 1.4.2.3 2005/01/21 16:51:20 otsuka Exp $
 */
public interface VelocityMailBuilder extends MailBuilder {

	/**
	 * ꤵ줿饹ѥΥեɤ߹Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤեΥѥ
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(String classPath, VelocityContext context) throws MailBuildException;

	/**
	 * ꤵ줿եɤ߹Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param file ᡼Ƥ򵭽Ҥե
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(File file, VelocityContext context) throws MailBuildException;

	/**
	 * ᡼ǡå򥯥ꥢޤ
	 * 
	 * @since 1.1.2
	 */
	void clearCache();

	/**
	 * VelocityContextȥޡΥ᡼ǡ򥭥å夹뤫ɤꤷޤ
	 * ǥեȤϥå夷ʤǤ
	 * <p>
	 * åΥϡ<code>buildMail()</code>᥽åɰΥ᡼ǡեΥ饹ѥϥեѥǤ
	 * åͭ¤Ϥޤ
	 * ޤ᡼ǡեƤǹƤ⡢å夵Ƥ᡼ǡϹޤΤդƤ
	 * <p>
	 * <code>false</code>ꤷƤΥ᥽åɤƤ֤ȥ᡼ǡåϥꥢޤ
	 * 
	 * @since 1.1.2
	 * @param cacheEnabled ᡼ǡ򥭥å夹 true
	 */
	void setCacheEnabled(boolean cacheEnabled);

	/**
	 * VelocityContextȥޡΥ᡼ǡ򥭥å夹꤫ɤȽꤷޤ
	 * 
	 * @since 1.1.2
	 * @return ᡼ǡ򥭥å夹ξ true
	 */
	boolean isCacheEnabled();

}