package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.SendMail;

/**
 * SendMail󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: SendMailImpl.java,v 1.7.2.5 2006/08/07 13:45:22 otsuka Exp $
 */
public class SendMailImpl implements SendMail {

	private static Log log = LogFactory.getLog(SendMailImpl.class);

	/** ǥեȤΥץȥ롣smtp */
	public static final String DEFAULT_PROTOCOL = "smtp";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 * */
	public static final int DEFAULT_PORT = -1;

	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ISO-2022-JP */
	public static final String JIS_CHARSET = "ISO-2022-JP";

	private static final String RETURN_PATH_KEY = "mail.smtp.from";

	/** ³ॢ */
	private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	/** ɹॢ */
	private static final int DEFAULT_READ_TIMEOUT = 5000;

	private String protocol = DEFAULT_PROTOCOL;

	private String host = DEFAULT_HOST;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private String charset = JIS_CHARSET;

	private String returnPath;

	private String messageId;

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	/**
	 * 󥹥ȥ饯
	 */
	public SendMailImpl() {}

	/**
	 * 󥹥ȥ饯ѤSMTPФꤷޤ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public SendMailImpl(String host) {
		this();
		setHost(host);
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail)
	 */
	public void send(Mail mail) throws MailException {
		send(new Mail[] { mail });
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail[])
	 */
	public void send(Mail[] mails) throws MailException {
		MimeMessageWrapper[] mmws = new MimeMessageWrapper[mails.length];
		Session session = Session.getInstance(new Properties());
		for (int i = 0; i < mails.length; i++) {
			Mail mail = mails[i];

			// MimeMessage
			MimeMessage message = createMimeMessage(session);
			if (isMessageIdCustomized()) {
				mail.addHeader("Message-ID", ((OMLMimeMessage)message).getMessageId());
			}
			MimeMessageBuilder builder = new MimeMessageBuilder(message);
			try {
				builder.buildMimeMessage(mail);
			} catch (UnsupportedEncodingException e) {
				throw new MailBuildException("ݡȤƤʤʸɤꤵޤ", e);
			} catch (MessagingException e) {
				throw new MailBuildException("MimeMessage˼Ԥޤ", e);
			}

			// Return-Path
			String returnPath;
			if (mail.getReturnPath() != null) {
				returnPath = mail.getReturnPath().getAddress();
			} else {
				returnPath = this.returnPath;
			}

			mmws[i] = new MimeMessageWrapper(message, returnPath, mail.getEnvelopeTo());
		}
		processSend(mmws);
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage)
	 */
	public void send(MimeMessage message) throws MailException {
		send(new MimeMessage[] { message });
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage[])
	 */
	public void send(MimeMessage[] messages) throws MailException {
		MimeMessageWrapper[] mmws = new MimeMessageWrapper[messages.length];
		for (int i = 0; i < messages.length; i++) {
			mmws[i] = new MimeMessageWrapper(messages[i], returnPath);
		}
		processSend(mmws);
	}

	private void processSend(MimeMessageWrapper[] mmws) throws MailException {

		Properties prop = new Properties();
		// ॢȤ
		prop.put("mail.smtp.connectiontimeout", String.valueOf(connectionTimeout));
		prop.put("mail.smtp.timeout", String.valueOf(readTimeout));
		//	mail.smtp.authץѥƥ
		if (username != null && !"".equals(username) && password != null && !"".equals(password)) {
			prop.put("mail.smtp.auth", "true");
		}
		Session session = Session.getInstance(prop);

		Transport transport = null;
		try {
			// SMTPФ³
			log.debug("SMTP[" + host + "]³ޤ");
			transport = session.getTransport(protocol);
			transport.connect(host, port, username, password);
			log.debug("SMTP[" + host + "]³ޤ");

			for (int i = 0; i < mmws.length; i++) {
				MimeMessage mimeMessage = mmws[i].getMimeMessage();
				//	Return-Path򥻥å
				String returnPath = mmws[i].getReturnPath();
				if (returnPath != null) {
					session.getProperties().put(RETURN_PATH_KEY, returnPath);
					log.debug("Return-Path[" + returnPath + "]ꤷޤ");
				}
				// 򥻥å
				mimeMessage.setSentDate(new Date());
				mimeMessage.saveChanges();

				// 
				log.debug("᡼ޤ");
				if (mmws[i].hasEnvelopeTo()) {
					log.debug("᡼envelope-toɥ쥹ޤ");
					transport.sendMessage(mimeMessage, mmws[i].getEnvelopeTo());
				} else {
					transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
				}
				log.debug("᡼ޤ");

				// Return-Path
				if (returnPath != null) {
					session.getProperties().remove(RETURN_PATH_KEY);
					log.debug("Return-Path򥯥ꥢޤ");
				}
			}
		} catch (AuthenticationFailedException ex) {
			log.error("SMTP[" + host + "]ؤ³ǧڤ˼Ԥޤ", ex);
			throw new MailAuthenticationException(ex);
		} catch (MessagingException ex) {
			log.error("᡼˼Ԥޤ", ex);
			throw new MailSendException("᡼˼Ԥޤ", ex);
		} finally {
			if (transport != null && transport.isConnected()) {
				log.debug("SMTP[" + host + "]Ȥ³Ǥޤ");
				try {
					// SMTPФȤ³
					transport.close();
				} catch (MessagingException e) {
					log.error("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ", e);
					throw new MailException("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ");
				}
				log.debug("SMTP[" + host + "]Ȥ³Ǥޤ");
			}
		}
	}

	/**
	 * MimeMessage֥Ȥޤ<br>
	 * messageIdץѥƥåȤƤ硢OMLMimeMessageΥ󥹥󥹤ޤ
	 * 
	 * @return MimeMessage֥
	 */
	private MimeMessage createMimeMessage(Session session) {
		if (isMessageIdCustomized()) {
			return new OMLMimeMessage(session, messageId);
		}
		return new MimeMessage(session);
	}

	/**
	 * Message-IdإåΥɥᥤʬȼ˥åȤƤ뤫ɤȽꤷޤ
	 * 
	 * @return Message-IdإåΥɥᥤʬȼ˥åȤƤ true
	 */
	private boolean isMessageIdCustomized() {
		return messageId != null;
	}

	/**
	 * 󥳡ǥ󥰤˻Ѥʸɤ֤ޤ
	 * 
	 * @return 󥳡ǥ󥰤˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ᡼η̾ʸΥ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * ǥեȤ<code>ISO-2022-JP</code>Ǥ
	 * <p>
	 * ܸĶѤ̾ѹɬפϤޤ
	 * 
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * åȤ줿SMTPФΥۥ̾ޤIPɥ쥹֤ޤ
	 * 
	 * @return SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public String getHost() {
		return host;
	}

	/**
	 * SMTPФΥۥ̾ޤIPɥ쥹򥻥åȤޤ
	 * ǥեȤ localhost Ǥ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return SMTPǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥ѥɤ򥻥åȤޤ
	 * 
	 * @param password SMTPǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return SMTPФΥݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * SMTPФΥݡֹ򥻥åȤޤ
	 * 
	 * @param port SMTPФΥݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * ץȥ֤ޤ
	 * 
	 * @return ץȥ
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * ץȥ򥻥åȤޤǥեȤϡsmtpס
	 * 
	 * @param protocol ץȥ
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Return-Pathɥ쥹
	 */
	public String getReturnPath() {
		return returnPath;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * <p>
	 * Mail󥹥󥹤˻ꤵ줿Fromɥ쥹ʳΥɥ쥹Return-PathȤ˻Ѥޤ
	 * ǥåȤ줿Return-PathꡢMail󥹥󥹤˥åȤ줿Return-Pathͥ褵ޤ
	 * 
	 * @param returnPath Return-Pathɥ쥹
	 */
	public void setReturnPath(String returnPath) {
		this.returnPath = returnPath;
	}

	/**
	 * @return SMTPǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥桼̾򥻥åȤޤ
	 * 
	 * @param username SMTPǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * SMTPФȤ³ॢȤ򥻥åȤޤ
	 * ñ̤ϥߥáǥեȤ5,000ߥ(5)Ǥ
	 * <p>
	 * -1ꤹ̵ˤʤޤᤷޤ
	 * 
	 * @since 1.1.4
	 * @param connectionTimeout SMTPФȤ³ॢ
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * SMTPФؤΥॢȤ򥻥åȤޤ
	 * ñ̤ϥߥáǥեȤ5,000ߥ(5)Ǥ<br>
	 * ˥ॢȤȡ<code>com.ozacc.mail.MailSendException</code>ޤ
	 * <p>
	 * -1ꤹ̵ˤʤޤᤷޤ
	 * 
	 * @since 1.1.4
	 * @param readTimeout SMTPФؤΥॢ
	 */
	public void setReadTimeout(int readTimeout) {
		this.readTimeout = readTimeout;
	}

	/**
	 * MimeMessageդMessage-IdإåΥɥᥤʬꤷޤ<br>
	 * ꤵʤ(nullʸξ)ϡJavaMailMessage-Idإåޤ
	 * JavaMailJavaMail.¹ԥ桼̾@ۥ̾פMessage-Id򤱤ˡΥ᥽åɤѤޤ
	 * <p>
	 * messageIdץѥƥåȤƤ硢MailMimeMessageMessage-Idˤ
	 * <code>ॹ + 16ο + ǥåȤ줿</code>
	 * Ѥޤ
	 * <p>
	 * Message-Id㡣 (ºݤοʬ᡼Ѥޤ)<ul>
	 * <li>messageId'example.com'ꤷ硦1095714924963.5619528074501343@example.com</li>
	 * <li>messageId'@example.com'ꤷ硦1095714924963.5619528074501343@example.com (Ʊ)</li>
	 * <li>messageId'OML@example.com'ꤷ硦1095714924963.5619528074501343.OML@example.com</li>
	 * <li>messageId'.OML@example.com'ꤷ硦1095714924963.5619528074501343.OML@example.com (Ʊ)</li>
	 * </ul>
	 * <p>
	 * <strong>:</strong> Message-Id<code>send(Mail)</code><code>send(Mail[])</code>᥽åɤƤӤ줿ˤΤͭǤMimeMessageľˤŬѤޤ
	 * 
	 * @param messageId ᡼դMessage-IdإåΥɥᥤʬ
	 * @throws IllegalArgumentException @ʣޤʸꤷ
	 */
	public void setMessageId(String messageId) {
		if (messageId == null || messageId.length() < 1) {
			return;
		}

		String[] parts = messageId.split("@");
		if (parts.length > 2) {
			throw new IllegalArgumentException("messageIdץѥƥ'@'ʣޤळȤϤǤޤ[" + messageId
					+ "]");
		}

		this.messageId = messageId;
	}

	/**
	 * MimeMessage󥹥󥹤ȡΥ᡼бReturn-Pathenvelope-toɥ쥹åפ륯饹
	 * 
	 * @author Tomohiro Otsuka
	 * @version $Id: SendMailImpl.java,v 1.7.2.5 2006/08/07 13:45:22 otsuka Exp $
	 */
	private static class MimeMessageWrapper {

		private MimeMessage mimeMessage;

		private String returnPath;

		private InternetAddress[] envelopeTo;

		public MimeMessageWrapper(MimeMessage mimeMessage, String returnPath) {
			this.mimeMessage = mimeMessage;
			this.returnPath = returnPath;
		}

		public MimeMessageWrapper(MimeMessage mimeMessage, String returnPath,
				InternetAddress[] envelopeTo) {
			this.mimeMessage = mimeMessage;
			this.returnPath = returnPath;
			this.envelopeTo = envelopeTo;
		}

		public MimeMessage getMimeMessage() {
			return mimeMessage;
		}

		public String getReturnPath() {
			return returnPath;
		}

		public boolean hasEnvelopeTo() {
			return envelopeTo.length > 0;
		}

		public InternetAddress[] getEnvelopeTo() {
			return envelopeTo;
		}
	}

}