package com.ozacc.mail.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

import com.ozacc.mail.fetch.FetchMailPro;
import com.ozacc.mail.fetch.ReceivedMail;
import com.ozacc.mail.mailet.MailetWrapper;

/**
 * Spring FrameworkQuartz¹MailetRunner
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MailetRunnerJob.java,v 1.1.2.3 2005/01/23 06:47:16 otsuka Exp $
 */
public class MailetRunnerJob extends QuartzJobBean {

	private List mailetWrapperList;

	private FetchMailPro fetchMailPro;

	/**
	 * 󥹥ȥ饯
	 */
	public MailetRunnerJob() {
		mailetWrapperList = new ArrayList();
	}

	/**
	 * ᡼MailetεưԤޤ
	 * 
	 * @see org.springframework.scheduling.quartz.QuartzJobBean#executeInternal(org.quartz.JobExecutionContext)
	 */
	protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
		fetchMailPro.connect();
		try {
			int count = fetchMailPro.getMailCount();
			for (int i = 1; i <= count; i++) {
				ReceivedMail mail = fetchMailPro.getMail(i);
				processMail(mail);
			}
		} finally {
			if (fetchMailPro.isConnected()) {
				fetchMailPro.disconnect();
			}
		}
	}

	/**
	 * ꤵ줿᡼ФMailetŬѤޤ
	 * 
	 * @param mail MailetUnitϤ᡼
	 */
	private void processMail(ReceivedMail mail) {
		for (Iterator itr = mailetWrapperList.iterator(); itr.hasNext();) {
			MailetWrapper mailetWrapper = (MailetWrapper)itr.next();
			mailetWrapper.execute(mail);
		}
	}

	/**
	 * ᡼μ˻ѤFetchMailPro󥿡եμ󥹥󥹤򥻥åȤޤ
	 * 
	 * @param fetchMailPro FetchMailPro󥿡եμ󥹥
	 */
	public void setFetchMailPro(FetchMailPro fetchMailPro) {
		this.fetchMailPro = fetchMailPro;
	}

	/**
	 * ¹ԤMailetMailetWrapperꥹȤ򥻥åȤޤ
	 * 
	 * @param mailetWrapperList ¹ԤMailetMailetWrapperꥹ
	 */
	public void setMailetWrapperList(List mailetWrapperList) {
		this.mailetWrapperList = mailetWrapperList;
	}

}