/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.io;

import java.io.IOException;
import java.io.InputStream;
import org.sqlite.io.Closeable;

public abstract class InputStreamAdapter
extends InputStream {
    private final Closeable owner;
    private final long last;
    private long pos;
    private long mark;
    private boolean isClosed = false;

    public InputStreamAdapter(Closeable owner, long len) {
        this.owner = owner;
        this.last = len - 1L;
    }

    public int available() throws IOException {
        this.validateStreamOpen();
        return this.pos > this.last ? 0 : (int)(this.last - this.pos);
    }

    public void close() {
        this.isClosed = true;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) != -1 ? b[0] : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.validateStreamOpen();
        if (this.pos > this.last) {
            return -1;
        }
        if (this.pos + (long)len > this.last) {
            len = (int)((long)len - (this.pos + (long)len - (this.last + 1L)));
        }
        if (len == 0) {
            return 0;
        }
        this.read(this.pos, b, off, len);
        this.pos += (long)len;
        return len;
    }

    public synchronized void reset() throws IOException {
        this.validateStreamOpen();
        this.pos = this.mark;
    }

    public long skip(long n) throws IOException {
        this.validateStreamOpen();
        if (this.pos > this.last) {
            return 0L;
        }
        this.pos += n;
        return this.pos > this.last ? n - (this.pos - this.last) : n;
    }

    private void validateStreamOpen() throws IOException {
        if (this.isClosed || this.owner.isClosed()) {
            throw new IOException("Stream is already closed.");
        }
    }

    protected abstract void read(long var1, byte[] var3, int var4, int var5) throws IOException;
}

