/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.sqlite.Blob;
import org.sqlite.io.BlobInputStream;
import org.sqlite.io.BlobOutputStream;
import org.sqlite.io.Closeable;
import org.sqlite.io.MemoryInputStream;
import org.sqlite.io.WrappedIOException;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SWIGTYPE_p_void;

public class JdbcBlob
implements java.sql.Blob,
Closeable {
    private final Closeable owner;
    private final SWIGTYPE_p_void ptr;
    private final Blob blob;
    private final long length;
    private boolean isClosed = false;

    public JdbcBlob(Closeable owner, SWIGTYPE_p_void blob, long len) {
        this.owner = owner;
        this.ptr = blob;
        this.length = len;
        this.blob = null;
    }

    public JdbcBlob(Closeable owner, Blob blob) throws SQLException {
        this.owner = owner;
        this.blob = blob;
        this.length = blob.length();
        this.ptr = null;
    }

    public long length() {
        return this.length;
    }

    public byte[] getBytes(long pos, int len) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Should pos is greater than or equal to 1.", "90J08");
        }
        if (len < 0) {
            throw new SQLException("Should len is greater than or equal to 0.", "90J08");
        }
        if (len == 0) {
            return new byte[0];
        }
        if (pos + (long)len > this.length) {
            len = (int)((long)len - (pos + (long)len - this.length - 1L));
        }
        byte[] b = new byte[len];
        InputStream in = this.getBinaryStream();
        try {
            in.skip(pos - 1L);
            in.read(b, 0, len);
            return b;
        }
        catch (WrappedIOException ex) {
            throw ex.getCause();
        }
        catch (IOException ex) {
            SQLException sqlex = new SQLException(ex.getMessage());
            sqlex.initCause(ex);
            throw sqlex;
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.blob != null ? new BlobInputStream((Closeable)this, this.blob) : new MemoryInputStream(this, this.ptr, this.length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int ret = JdbcBlob.BM(pattern, this.getBytes(start, (int)this.length));
        return ret > 0 ? ret + 1 : -1;
    }

    public long position(java.sql.Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (this.blob != null) {
            return this.setBytes(pos, bytes, 0, bytes.length);
        }
        throw new JdbcSQLException(8);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.blob != null) {
            try {
                this.setBinaryStream(pos).write(bytes, offset, len);
                return len;
            }
            catch (IOException ex) {
                throw (SQLException)ex.getCause();
            }
        }
        throw new JdbcSQLException(8);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blob != null) {
            return new BlobOutputStream(this, this.blob, pos);
        }
        throw new JdbcSQLException(8);
    }

    public void truncate(long len) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed || this.owner.isClosed();
    }

    private static int[] preBmBc(byte[] x) {
        int i;
        int ASIZE = 256;
        int[] bmBc = new int[256];
        int m = x.length;
        for (i = 0; i < 256; ++i) {
            bmBc[i] = m;
        }
        for (i = 0; i < m - 1; ++i) {
            bmBc[x[i] < 0 ? 127 - x[i] : x[i]] = m - i - 1;
        }
        return bmBc;
    }

    private static int[] suffixes(byte[] x) {
        int m = x.length;
        int[] suff = new int[m];
        suff[m - 1] = m;
        int g = m - 1;
        int f = 0;
        for (int i = m - 2; i >= 0; --i) {
            if (i > g && suff[i + m - 1 - f] < i - g) {
                suff[i] = suff[i + m - 1 - f];
                continue;
            }
            if (i < g) {
                g = i;
            }
            f = i;
            while (g >= 0 && x[g] == x[g + m - 1 - f]) {
                --g;
            }
            suff[i] = f - g;
        }
        return suff;
    }

    private static int[] preBmGs(byte[] x) {
        int i;
        int[] suff = JdbcBlob.suffixes(x);
        int m = x.length;
        int[] bmGs = new int[m];
        for (int i2 = 0; i2 < m; ++i2) {
            bmGs[i2] = m;
        }
        int j = 0;
        for (i = m - 1; i >= 0; --i) {
            if (suff[i] != i + 1) continue;
            while (j < m - 1 - i) {
                if (bmGs[j] == m) {
                    bmGs[j] = m - 1 - i;
                }
                ++j;
            }
        }
        for (i = 0; i <= m - 2; ++i) {
            bmGs[m - 1 - suff[i]] = m - 1 - i;
        }
        return bmGs;
    }

    private static int BM(byte[] x, byte[] y) {
        int b;
        int i;
        int[] bmGs = JdbcBlob.preBmGs(x);
        int[] bmBc = JdbcBlob.preBmBc(x);
        int m = x.length;
        int n = y.length;
        int end = n - m + 1;
        for (int j = 0; j < end; j += Math.max(bmGs[i], bmBc[b < 0 ? 127 - b : b] - m + 1 + i)) {
            i = 0;
            for (i = m - 1; i >= 0 && x[i] == y[i + j]; --i) {
            }
            if (i < 0) {
                return j;
            }
            b = y[i + j];
        }
        return -1;
    }
}

