/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;

public class JdbcSQLException
extends SQLException {
    private static final List<Integer> NOT_FATAL_ERROR;

    public JdbcSQLException(int resultCode) {
        this(SQLite3.sqlite3_get_errmsg(resultCode), resultCode);
    }

    public JdbcSQLException(String reason, int vendorCode) {
        super(reason, JdbcSQLException.getSQLState(vendorCode), vendorCode);
        this.log(reason, vendorCode);
    }

    public JdbcSQLException(int resultCode, SWIGTYPE_p_sqlite3 db) {
        this(resultCode, SQLite3.sqlite3_get_errmsg(resultCode), db);
    }

    public JdbcSQLException(int resultCode, SWIGTYPE_p_sqlite3_stmt stmt) {
        this(resultCode, SQLite3.sqlite3_db_handle(stmt));
    }

    private JdbcSQLException(int resultCode, String message, SWIGTYPE_p_sqlite3 db) {
        super(message, JdbcSQLException.getSQLState(resultCode), resultCode);
        this.log(message, resultCode);
        int errorCode = SQLite3.sqlite3_errcode(db);
        if (errorCode != 0 && errorCode != resultCode) {
            JdbcSQLException ex = new JdbcSQLException(SQLite3.sqlite3_errmsg(db), errorCode);
            ex.initCause(this);
            this.setNextException(ex);
        }
    }

    private void log(String reason, int vendorCode) {
        Logger logger;
        if (!NOT_FATAL_ERROR.contains(vendorCode) && (logger = Logger.getLogger(JdbcSQLException.class.getName())).isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(reason);
            message.append("\n");
            for (StackTraceElement trace : this.getStackTrace()) {
                message.append("\tat ").append(trace.toString()).append("\n");
            }
            logger.severe(message.toString());
        }
    }

    public static String getSQLState(int errcode) {
        String subclass = ("000" + errcode).substring(0, 3);
        switch (errcode) {
            case 0: 
            case 100: 
            case 101: {
                return "00" + subclass;
            }
            case 4: 
            case 9: {
                return "02" + subclass;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return "HY" + subclass;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return "90" + subclass;
            }
            case 19: {
                return "23" + subclass;
            }
            case 14: {
                return "08" + subclass;
            }
            case 21: {
                return "42" + subclass;
            }
        }
        return null;
    }

    static {
        int[] NOT_FATAL_ERROR_CODES = new int[]{0, 3, 4, 5, 6, 8, 9, 14, 17, 19, 23, 100, 101};
        NOT_FATAL_ERROR = new ArrayList<Integer>();
        for (int code : NOT_FATAL_ERROR_CODES) {
            NOT_FATAL_ERROR.add(code);
        }
    }
}

