/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Rectangle
implements Element,
MarkupAttributes {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected float llx;
    protected float lly;
    protected float urx;
    protected float ury;
    protected int border = -1;
    protected float borderWidth = -1.0f;
    protected Color color = null;
    protected Color background = null;
    protected float grayFill = 0.0f;
    protected int rotation = 0;
    protected Properties markupAttributes;

    public Rectangle(float llx, float lly, float urx, float ury) {
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public Rectangle(float urx, float ury) {
        this(0.0f, 0.0f, urx, ury);
    }

    public Rectangle(Rectangle rect) {
        this(rect.left(), rect.bottom(), rect.right(), rect.top());
        this.llx = rect.llx;
        this.lly = rect.lly;
        this.urx = rect.urx;
        this.ury = rect.ury;
        this.rotation = rect.rotation;
        this.border = rect.border;
        this.borderWidth = rect.borderWidth;
        this.color = rect.color;
        this.background = rect.background;
        this.grayFill = rect.grayFill;
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public Rectangle rectangle(float top, float bottom) {
        Rectangle tmp = new Rectangle(this);
        tmp.setBorder(this.border);
        tmp.setBorderWidth(this.borderWidth);
        tmp.setBorderColor(this.color);
        tmp.setBackgroundColor(this.background);
        tmp.setGrayFill(this.grayFill);
        if (this.top() > top) {
            tmp.setTop(top);
            tmp.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < bottom) {
            tmp.setBottom(bottom);
            tmp.setBorder(this.border - (this.border & 2));
        }
        return tmp;
    }

    public Rectangle rotate() {
        Rectangle rect = new Rectangle(this.lly, this.llx, this.ury, this.urx);
        rect.rotation = this.rotation + 90;
        rect.rotation %= 360;
        return rect;
    }

    public void setLeft(float value) {
        this.llx = value;
    }

    public void setRight(float value) {
        this.urx = value;
    }

    public void setTop(float value) {
        this.ury = value;
    }

    public void setBottom(float value) {
        this.lly = value;
    }

    public void setBorder(int value) {
        this.border = value;
    }

    public void setBorderWidth(float value) {
        this.borderWidth = value;
    }

    public void setBorderColor(Color value) {
        this.color = value;
    }

    public void setBackgroundColor(Color value) {
        this.background = value;
    }

    public void setGrayFill(float value) {
        if (value >= 0.0f && (double)value <= 1.0) {
            this.grayFill = value;
        }
    }

    public float left() {
        return this.llx;
    }

    public float right() {
        return this.urx;
    }

    public float top() {
        return this.ury;
    }

    public float bottom() {
        return this.lly;
    }

    public float left(float margin) {
        return this.llx + margin;
    }

    public float right(float margin) {
        return this.urx - margin;
    }

    public float top(float margin) {
        return this.ury - margin;
    }

    public float bottom(float margin) {
        return this.lly + margin;
    }

    public float width() {
        return this.urx - this.llx;
    }

    public float height() {
        return this.ury - this.lly;
    }

    public boolean hasBorders() {
        return this.border > 0 && this.borderWidth > 0.0f;
    }

    public boolean hasBorder(int type) {
        return this.border != -1 && (this.border & type) == type;
    }

    public int border() {
        return this.border;
    }

    public float borderWidth() {
        return this.borderWidth;
    }

    public Color borderColor() {
        return this.color;
    }

    public Color backgroundColor() {
        return this.background;
    }

    public float grayFill() {
        return this.grayFill;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setMarkupAttribute(String name, String value) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(name, value);
    }

    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(name));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

