/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode128
extends Barcode {
    static byte[][] BARS = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    static byte[] BARS_STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1_INDEX = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';
    public static final char FNC1 = '\u00ca';
    public static final char DEL = '\u00c3';
    public static final char FNC3 = '\u00c4';
    public static final char FNC2 = '\u00c5';
    public static final char SHIFT = '\u00c6';
    public static final char CODE_C = '\u00c7';
    public static final char CODE_A = '\u00c8';
    public static final char FNC4 = '\u00c8';
    public static final char STARTA = '\u00cb';
    public static final char STARTB = '\u00cc';
    public static final char STARTC = '\u00cd';

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean isNextDigits(String text, int textIndex, int numDigits) {
        if (textIndex + numDigits <= text.length()) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((c = text.charAt(textIndex++)) >= '0' && c <= '9') continue;
            return false;
lbl5:
            // 2 sources

            ** while (numDigits-- > 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    static String getPackedRawDigits(String text, int textIndex, int numDigits) {
        String out = "";
        while (numDigits > 0) {
            numDigits -= 2;
            int c1 = text.charAt(textIndex++) - 48;
            int c2 = text.charAt(textIndex++) - 48;
            out = String.valueOf(out) + (char)(c1 * 10 + c2);
        }
        return out;
    }

    public static String getRawText(String text, boolean ucc) {
        String out = "";
        int tLen = text.length();
        if (tLen == 0) {
            out = String.valueOf(out) + 'h';
            if (ucc) {
                out = String.valueOf(out) + 'f';
            }
            return out;
        }
        char c = '\u0000';
        int k = 0;
        while (k < tLen) {
            c = text.charAt(k);
            if (c > '\u007f') {
                throw new RuntimeException("There are illegal characters for barcode 128 in '" + text + "'.");
            }
            ++k;
        }
        c = text.charAt(0);
        int currentCode = 104;
        int index = 0;
        if (Barcode128.isNextDigits(text, index, 2)) {
            currentCode = 105;
            out = String.valueOf(out) + (char)currentCode;
            if (ucc) {
                out = String.valueOf(out) + 'f';
            }
            out = String.valueOf(out) + Barcode128.getPackedRawDigits(text, index, 2);
            index += 2;
        } else if (c < ' ') {
            currentCode = 103;
            out = String.valueOf(out) + (char)currentCode;
            if (ucc) {
                out = String.valueOf(out) + 'f';
            }
            out = String.valueOf(out) + (char)(c + 64);
            ++index;
        } else {
            out = String.valueOf(out) + (char)currentCode;
            if (ucc) {
                out = String.valueOf(out) + 'f';
            }
            out = String.valueOf(out) + (char)(c - 32);
            ++index;
        }
        while (index < tLen) {
            switch (currentCode) {
                case 103: {
                    if (Barcode128.isNextDigits(text, index, 4)) {
                        currentCode = 105;
                        out = String.valueOf(out) + 'c';
                        out = String.valueOf(out) + Barcode128.getPackedRawDigits(text, index, 4);
                        index += 4;
                        break;
                    }
                    if ((c = text.charAt(index++)) > '_') {
                        currentCode = 104;
                        out = String.valueOf(out) + 'd';
                        out = String.valueOf(out) + (char)(c - 32);
                        break;
                    }
                    if (c < ' ') {
                        out = String.valueOf(out) + (char)(c + 64);
                        break;
                    }
                    out = String.valueOf(out) + (char)(c - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.isNextDigits(text, index, 4)) {
                        currentCode = 105;
                        out = String.valueOf(out) + 'c';
                        out = String.valueOf(out) + Barcode128.getPackedRawDigits(text, index, 4);
                        index += 4;
                        break;
                    }
                    if ((c = text.charAt(index++)) < ' ') {
                        currentCode = 103;
                        out = String.valueOf(out) + 'e';
                        out = String.valueOf(out) + (char)(c + 64);
                        break;
                    }
                    out = String.valueOf(out) + (char)(c - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.isNextDigits(text, index, 2)) {
                        out = String.valueOf(out) + Barcode128.getPackedRawDigits(text, index, 2);
                        index += 2;
                        break;
                    }
                    if ((c = text.charAt(index++)) < ' ') {
                        currentCode = 103;
                        out = String.valueOf(out) + 'e';
                        out = String.valueOf(out) + (char)(c + 64);
                        break;
                    }
                    currentCode = 104;
                    out = String.valueOf(out) + 'd';
                    out = String.valueOf(out) + (char)(c - 32);
                }
            }
        }
        return out;
    }

    public static byte[] getBarsCode128Raw(String text) {
        int idx = text.indexOf(65535);
        if (idx >= 0) {
            text = text.substring(0, idx);
        }
        int chk = text.charAt(0);
        int k = 1;
        while (k < text.length()) {
            chk += k * text.charAt(k);
            ++k;
        }
        text = String.valueOf(text) + (char)(chk %= 103);
        byte[] bars = new byte[(text.length() + 1) * 6 + 7];
        int k2 = 0;
        while (k2 < text.length()) {
            System.arraycopy(BARS[text.charAt(k2)], 0, bars, k2 * 6, 6);
            ++k2;
        }
        System.arraycopy(BARS_STOP, 0, bars, k2 * 6, 7);
        return bars;
    }

    public Rectangle getBarcodeSize() {
        int idx;
        String fullCode;
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fullCode = this.code;
            if (this.codeType == 11) {
                idx = this.code.indexOf(65535);
                fullCode = idx < 0 ? "" : this.code.substring(idx + 1);
            }
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        fullCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int len = fullCode.length();
        float fullWidth = (float)((len + 2) * 11) * this.x + 2.0f * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        int idx;
        String fullCode = this.code;
        if (this.codeType == 11) {
            int idx2 = this.code.indexOf(65535);
            fullCode = idx2 < 0 ? "" : this.code.substring(idx2 + 1);
        }
        float fontX = 0.0f;
        if (this.font != null) {
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        String bCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int len = bCode.length();
        float fullWidth = (float)((len + 2) * 11) * this.x + 2.0f * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        byte[] bars = Barcode128.getBarsCode128Raw(bCode);
        boolean print = true;
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w = (float)bars[k] * this.x;
            if (print) {
                cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(fullCode);
            cb.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        int idx;
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        String bCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        int len = bCode.length();
        int fullWidth = (len + 2) * 11 + 2;
        byte[] bars = Barcode128.getBarsCode128Raw(bCode);
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[fullWidth * height];
        int k = 0;
        while (k < bars.length) {
            int w = bars[k];
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            int j = 0;
            while (j < w) {
                pix[ptr++] = c;
                ++j;
            }
            ++k;
        }
        k = fullWidth;
        while (k < pix.length) {
            System.arraycopy(pix, 0, pix, k, fullWidth);
            k += fullWidth;
        }
        Image img = canvas.createImage(new MemoryImageSource(fullWidth, height, pix, 0, fullWidth));
        return img;
    }
}

