/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.inline.ForeignObjectArea;

public class InstreamForeignObject
extends FObj {
    int breakBefore;
    int breakAfter;
    int scaling;
    int width;
    int height;
    int contwidth;
    int contheight;
    boolean wauto;
    boolean hauto;
    boolean cwauto;
    boolean chauto;
    int spaceBefore;
    int spaceAfter;
    int startIndent;
    int endIndent;
    ForeignObjectArea areaCurrent;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public InstreamForeignObject(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:instream-foreign-object";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            String id = this.properties.get("id").getString();
            int align = this.properties.get("text-align").getEnum();
            int valign = this.properties.get("vertical-align").getEnum();
            int overflow = this.properties.get("overflow").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.contwidth = this.properties.get("content-width").getLength().mvalue();
            this.contheight = this.properties.get("content-height").getLength().mvalue();
            this.wauto = this.properties.get("width").getLength().isAuto();
            this.hauto = this.properties.get("height").getLength().isAuto();
            this.cwauto = this.properties.get("content-width").getLength().isAuto();
            this.chauto = this.properties.get("content-height").getLength().isAuto();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.scaling = this.properties.get("scaling").getEnum();
            try {
                area.getIDReferences().createID(id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            if (this.areaCurrent == null) {
                this.areaCurrent = new ForeignObjectArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth());
                this.areaCurrent.start();
                this.areaCurrent.setWidth(this.width);
                this.areaCurrent.setHeight(this.height);
                this.areaCurrent.setContentWidth(this.contwidth);
                this.areaCurrent.setContentHeight(this.contheight);
                this.areaCurrent.setScaling(this.scaling);
                this.areaCurrent.setAlign(align);
                this.areaCurrent.setVerticalAlign(valign);
                this.areaCurrent.setOverflow(overflow);
                this.areaCurrent.setSizeAuto(this.wauto, this.hauto);
                this.areaCurrent.setContentSizeAuto(this.cwauto, this.chauto);
                this.areaCurrent.setPage(area.getPage());
                int numChildren = this.children.size();
                if (numChildren > 1) {
                    throw new FOPException("Only one child element is allowed in an instream-foreign-object", this.systemId, this.line, this.column);
                }
                if (this.children.size() > 0) {
                    FONode fo = (FONode)this.children.get(0);
                    int status = fo.layout(this.areaCurrent);
                    if (Status.isIncomplete(status)) {
                        return status;
                    }
                    this.areaCurrent.end();
                }
            }
            this.marker = 0;
            if (this.breakBefore == 83 || this.spaceBefore + this.areaCurrent.getEffectiveHeight() > area.spaceLeft()) {
                return 4;
            }
            if (this.breakBefore == 80) {
                return 6;
            }
            if (this.breakBefore == 35) {
                return 5;
            }
        }
        if (this.areaCurrent == null) {
            return 1;
        }
        if (area instanceof BlockArea) {
            BlockArea ba = (BlockArea)area;
            LineArea la = ba.getCurrentLineArea();
            if (la == null) {
                return 2;
            }
            la.addPending();
            if (this.areaCurrent.getEffectiveWidth() > la.getRemainingWidth() && (la = ba.createNextLineArea()) == null) {
                return 2;
            }
            la.addInlineArea(this.areaCurrent, this.getLinkSet());
        } else {
            area.addChild(this.areaCurrent);
            area.increaseHeight(this.areaCurrent.getEffectiveHeight());
        }
        if (this.isInTableCell) {
            this.startIndent += this.forcedStartOffset;
        }
        this.areaCurrent.setStartIndent(this.startIndent);
        this.areaCurrent.setPage(area.getPage());
        if (this.breakAfter == 83) {
            this.marker = -1001;
            return 4;
        }
        if (this.breakAfter == 80) {
            this.marker = -1001;
            return 6;
        }
        if (this.breakAfter == 35) {
            this.marker = -1001;
            return 5;
        }
        this.areaCurrent = null;
        return 1;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new InstreamForeignObject(parent, propertyList, systemId, line, column);
        }
    }
}

