/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.awt.FontSetup;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUtilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGRenderer
extends AbstractRenderer {
    static final String svgNS = "http://www.w3.org/2000/svg";
    Document svgDocument;
    Element svgRoot;
    Element currentPageG = null;
    Element lastLink = null;
    float totalWidth = 0.0f;
    float totalHeight = 0.0f;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected int pageNumber = 0;
    protected Map fontNames = new HashMap();
    protected Map fontStyles = new HashMap();
    protected Color saveColor = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected Map options;

    public void setOptions(Map options) {
        this.options = options;
    }

    protected void addLine(int x1, int y1, int x2, int y2, int th, float r, float g, float b) {
        Element line = SVGUtilities.createLine(this.svgDocument, (float)x1 / 1000.0f, (float)this.pageHeight - (float)y1 / 1000.0f, (float)x2 / 1000.0f, (float)this.pageHeight - (float)y2 / 1000.0f);
        line.setAttributeNS(null, "style", "stroke-width:" + (float)Math.abs(th) / 1000.0f + ";stroke:rgb(" + (int)(255.0f * r) + "," + (int)(255.0f * g) + "," + (int)(255.0f * b) + ")");
        this.currentPageG.appendChild(line);
    }

    protected void addRect(int x, int y, int w, int h, float r, float g, float b) {
        Element rect = SVGUtilities.createRect(this.svgDocument, (float)x / 1000.0f, (float)this.pageHeight - (float)y / 1000.0f, (float)w / 1000.0f, (float)h / 1000.0f);
        rect.setAttributeNS(null, "style", "stroke:rgb(" + (int)(255.0f * r) + "," + (int)(255.0f * g) + "," + (int)(255.0f * b) + ")");
        this.currentPageG.appendChild(rect);
    }

    protected void addRect(int x, int y, int w, int h, float r, float g, float b, float fr, float fg, float fb) {
        Element rect = SVGUtilities.createRect(this.svgDocument, (float)x / 1000.0f, (float)this.pageHeight - (float)y / 1000.0f, (float)w / 1000.0f, (float)h / 1000.0f);
        rect.setAttributeNS(null, "style", "stroke:rgb(" + (int)(255.0f * r) + "," + (int)(255.0f * g) + "," + (int)(255.0f * b) + ");fill:rgb(" + (int)(255.0f * fr) + "," + (int)(255.0f * fg) + "," + (int)(255.0f * fb) + ")");
        this.currentPageG.appendChild(rect);
    }

    protected void addRect(int x, int y, int w, int h, boolean drawAsOutline) {
        int startx = (x + 500) / 1000;
        int starty = this.pageHeight - (y + 500) / 1000;
        int endx = (x + w + 500) / 1000;
        int endy = this.pageHeight - (y + h + 500) / 1000;
        if (drawAsOutline) {
            Element rect = SVGUtilities.createRect(this.svgDocument, startx, starty, endx - startx, endy - starty);
            rect.setAttributeNS(null, "style", "fill:none");
            this.currentPageG.appendChild(rect);
        } else {
            Element rect = SVGUtilities.createRect(this.svgDocument, startx, starty, endx - startx, starty - endy);
            rect.setAttributeNS(null, "style", "stroke:none");
            this.currentPageG.appendChild(rect);
        }
    }

    protected void addFilledRect(int x, int y, int w, int h, ColorType col) {
        float r = col.red();
        float g = col.green();
        float b = col.blue();
        this.addRect(x, y, w, h, r, g, b, r, g, b);
    }

    protected void drawFrame() {
        int width = this.pageWidth;
        int height = this.pageHeight;
        Element rect = SVGUtilities.createRect(this.svgDocument, 0.0f, 0.0f, width, height);
        rect.setAttributeNS(null, "style", "fill:none;stroke:black");
        this.currentPageG.appendChild(rect);
    }

    public void render(Page page, OutputStream stream) throws IOException {
        ++this.pageNumber;
        this.render(page);
    }

    public void render(Page page) throws IOException {
        this.idReferences = page.getIDReferences();
        int lastWidth = this.pageWidth;
        int lastHeight = this.pageHeight;
        this.pageWidth = (int)((double)((float)page.getWidth() / 1000.0f) + 0.5);
        this.pageHeight = (int)((double)((float)page.getHeight() / 1000.0f) + 0.5);
        if (this.lastLink != null && this.currentPageG != null) {
            this.lastLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + this.totalHeight + ", " + this.pageWidth + ", " + this.pageHeight + "))");
            this.currentPageG.appendChild(this.lastLink);
        }
        this.totalHeight += (float)this.pageHeight;
        if (this.totalWidth < (float)this.pageWidth) {
            this.totalWidth = this.pageWidth;
        }
        this.currentPageG = SVGUtilities.createG(this.svgDocument);
        this.currentPageG.setAttributeNS(null, "id", "Page-" + this.pageNumber);
        this.currentPageG.setAttributeNS(null, "style", "font-family:sanserif;font-size:12");
        this.svgRoot.appendChild(this.currentPageG);
        this.drawFrame();
        this.renderPage(page);
        this.currentPageG.setAttributeNS(null, "transform", "translate(0," + (this.totalHeight - (float)this.pageHeight) + ")");
        Element lastPageLink = this.svgDocument.createElementNS(svgNS, "a");
        if (this.lastLink != null) {
            lastPageLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + (this.totalHeight - (float)this.pageHeight - (float)lastHeight) + ", " + lastWidth + ", " + lastHeight + "))");
        } else {
            lastPageLink.setAttributeNS(null, "xlink:href", "#svgView(viewBox(0, " + (this.totalHeight - (float)this.pageHeight) + ", " + this.pageWidth + ", " + this.pageHeight + "))");
        }
        this.currentPageG.appendChild(lastPageLink);
        Element rect = SVGUtilities.createRect(this.svgDocument, 0.0f, 0.0f, this.pageWidth / 2, this.pageHeight);
        rect.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        lastPageLink.appendChild(rect);
        this.lastLink = this.svgDocument.createElementNS(svgNS, "a");
        rect = SVGUtilities.createRect(this.svgDocument, this.pageWidth / 2, 0.0f, this.pageWidth / 2, this.pageHeight);
        rect.setAttributeNS(null, "style", "fill:blue;visibility:hidden");
        this.lastLink.appendChild(rect);
    }

    public void renderPage(Page page) {
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderRegions(page);
    }

    protected void doFrame(Area area) {
        ColorType borderColor;
        int rx = this.currentAreaContainerXPosition;
        int w = area.getContentWidth();
        if (area instanceof BlockArea) {
            rx += ((BlockArea)area).getStartIndent();
        }
        int h = area.getContentHeight();
        int ry = this.currentYPosition;
        w = w + area.getPaddingLeft() + area.getPaddingRight();
        h = h + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, rx -= area.getPaddingLeft(), ry += area.getPaddingTop(), w, h);
        rx -= area.getBorderLeftWidth();
        ry += area.getBorderTopWidth();
        w = w + area.getBorderLeftWidth() + area.getBorderRightWidth();
        h = h + area.getBorderTopWidth() + area.getBorderBottomWidth();
        BorderAndPadding bp = area.getBorderAndPadding();
        if (area.getBorderTopWidth() != 0) {
            borderColor = bp.getBorderColor(0);
            this.addLine(rx, ry, rx + w, ry, area.getBorderTopWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderLeftWidth() != 0) {
            borderColor = bp.getBorderColor(3);
            this.addLine(rx, ry, rx, ry - h, area.getBorderLeftWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderRightWidth() != 0) {
            borderColor = bp.getBorderColor(1);
            this.addLine(rx + w, ry, rx + w, ry - h, area.getBorderRightWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
        if (area.getBorderBottomWidth() != 0) {
            borderColor = bp.getBorderColor(2);
            this.addLine(rx, ry - h, rx + w, ry - h, area.getBorderBottomWidth(), borderColor.red(), borderColor.green(), borderColor.blue());
        }
    }

    protected Rectangle2D getBounds(Area a) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, a.getAllocationWidth(), a.getHeight());
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        BufferedImage fontImage = new BufferedImage(100, 100, 1);
        FontSetup.setup(fontInfo, fontImage.createGraphics());
    }

    public void renderDisplaySpace(DisplaySpace space) {
        int d = space.getSize();
        this.currentYPosition -= d;
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        if (img == null) {
            this.log.error("Error while loading image : area.getImage() is null");
            this.addRect(x, y, w, h, true);
        } else if (img instanceof SVGImage) {
            try {
                SVGDocument svg = ((SVGImage)img).getSVGDocument();
                this.renderSVGDocument((Document)svg, (float)x / 1000.0f, (float)this.pageHeight - (float)y / 1000.0f);
            }
            catch (FopImageException e) {}
        } else {
            String urlString = img.getURL();
            try {
                URL url = new URL(urlString);
                ImageIcon icon = new ImageIcon(url);
                Image image = icon.getImage();
                int startx = (x + 500) / 1000;
                int starty = this.pageHeight - (y + 500) / 1000;
                int endx = (x + w + 500) / 1000;
                int endy = this.pageHeight - (y + h + 500) / 1000;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.currentXPosition += area.getContentWidth();
    }

    public void renderWordArea(WordArea area) {
        String fstyle;
        String fweight;
        StringBuffer pdf = new StringBuffer();
        String name = area.getFontState().getFontFamily();
        int size = area.getFontState().getFontSize();
        boolean underlined = area.getUnderlined();
        float red = area.getRed();
        float green = area.getGreen();
        float blue = area.getBlue();
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = name;
            this.currentFontSize = size;
        }
        if (red != this.currentRed || green != this.currentGreen || blue != this.currentBlue) {
            this.currentRed = red;
            this.currentGreen = green;
            this.currentBlue = blue;
        }
        int rx = this.currentXPosition;
        int bl = this.currentYPosition;
        String s = area.getText();
        if (this.saveColor != null) {
            if ((float)this.saveColor.getRed() != red || (float)this.saveColor.getGreen() != green || (float)this.saveColor.getBlue() != blue) {
                this.saveColor = new Color(red, green, blue);
            }
        } else {
            this.saveColor = new Color(red, green, blue);
        }
        Element text = SVGUtilities.createText(this.svgDocument, (float)rx / 1000.0f, (float)this.pageHeight - (float)bl / 1000.0f, s);
        String st = null;
        if (!"sans-serif".equals(this.currentFontName)) {
            st = "font-family:" + this.currentFontName;
        }
        if (this.currentFontSize != 12000) {
            st = st == null ? "" : String.valueOf(st) + ";";
            st = String.valueOf(st) + "font-size:" + (float)this.currentFontSize / 1000.0f;
        }
        if (red != 0.0f || green != 0.0f || blue != 0.0f) {
            st = st == null ? "" : String.valueOf(st) + ";";
            st = String.valueOf(st) + "fill:rgb(" + (int)(255.0f * red) + "," + (int)(255.0f * green) + "," + (int)(255.0f * blue) + ")";
        }
        if (!"normal".equals(fweight = area.getFontState().getFontWeight())) {
            st = st == null ? "" : String.valueOf(st) + ";";
            st = String.valueOf(st) + "font-weight:" + fweight;
        }
        if (!"normal".equals(fstyle = area.getFontState().getFontStyle())) {
            st = st == null ? "" : String.valueOf(st) + ";";
            st = String.valueOf(st) + "font-style:" + fstyle;
        }
        if (st != null) {
            text.setAttributeNS(null, "style", st);
        }
        this.currentPageG.appendChild(text);
        this.currentXPosition += area.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace space) {
        this.currentXPosition += space.getSize();
    }

    public void renderLeaderArea(LeaderArea area) {
        int rx = this.currentXPosition;
        int ry = this.currentYPosition;
        int w = area.getLeaderLength();
        int h = area.getHeight();
        int th = area.getRuleThickness();
        int st = area.getRuleStyle();
        float r = area.getRed();
        float g = area.getGreen();
        float b = area.getBlue();
        this.addRect(rx, ry, w, th, false);
        this.currentXPosition += area.getContentWidth();
    }

    public void renderSVGArea(SVGArea area) {
        float x = (float)this.currentXPosition / 1000.0f;
        float y = (float)this.pageHeight - (float)this.currentYPosition / 1000.0f;
        int w = area.getContentWidth();
        int h = area.getHeight();
        Document doc = area.getSVGDocument();
        this.renderSVGDocument(doc, x, y);
        this.currentXPosition += area.getContentWidth();
    }

    protected void renderSVGDocument(Document doc, float x, float y) {
        SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
        Element view = this.svgDocument.createElementNS(svgNS, "svg");
        Node newsvg = this.svgDocument.importNode((Node)svg, true);
        view.setAttributeNS(null, "x", "" + x);
        view.setAttributeNS(null, "y", "" + y);
        Element ele = (Element)newsvg;
        ele.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", svgNS);
        if (ele.hasAttributeNS(null, "xmlns")) {
            ele.removeAttributeNS(null, "xmlns");
        }
        view.appendChild(newsvg);
        this.currentPageG.appendChild(view);
    }

    public void setProducer(String producer) {
    }

    public static Color colorType2Color(ColorType ct) {
        if (ct == null) {
            return null;
        }
        return new Color(ct.red(), ct.green(), ct.blue());
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
        area.getObject().render(this);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        this.svgDocument = impl.createDocument(svgNS, "svg", null);
        ProcessingInstruction pi = this.svgDocument.createProcessingInstruction("xml", " version=\"1.0\" encoding=\"ISO-8859-1\"");
        this.svgRoot = this.svgDocument.getDocumentElement();
        this.svgDocument.insertBefore(pi, this.svgRoot);
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.svgRoot.setAttributeNS(null, "width", "" + this.totalWidth);
        this.svgRoot.setAttributeNS(null, "height", "" + this.totalHeight);
        SVGTranscoder svgT = new SVGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svgDocument);
        TranscoderOutput output = new TranscoderOutput((Writer)new OutputStreamWriter(outputStream));
        try {
            svgT.transcode(input, output);
        }
        catch (TranscoderException e) {
            this.log.error("could not write svg file :" + e.getMessage(), (Throwable)e);
        }
        outputStream.flush();
        this.svgDocument = null;
        this.svgRoot = null;
        this.currentPageG = null;
        this.lastLink = null;
        this.totalWidth = 0.0f;
        this.totalHeight = 0.0f;
        this.pageNumber = 0;
    }
}

