/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] newPainters = new ShapePainter[this.count * 3 / 2 + 1];
            System.arraycopy(this.painters, 0, newPainters, 0, this.count);
            this.painters = newPainters;
        }
        this.painters[this.count++] = shapePainter;
    }

    public ShapePainter getShapePainter(int index) {
        return this.painters[index];
    }

    public int getShapePainterCount() {
        return this.count;
    }

    public void paint(Graphics2D g2d) {
        if (this.painters != null) {
            int i = 0;
            while (i < this.count) {
                this.painters[i].paint(g2d);
                ++i;
            }
        }
    }

    public Shape getPaintedArea() {
        if (this.painters != null) {
            Area paintedArea = new Area();
            int i = 0;
            while (i < this.count) {
                Shape s = this.painters[i].getPaintedArea();
                if (s != null) {
                    paintedArea.add(new Area(s));
                }
                ++i;
            }
            return paintedArea;
        }
        return null;
    }

    public Rectangle2D getPaintedBounds2D() {
        if (this.painters != null) {
            GeneralPath paintedArea = new GeneralPath();
            int i = 0;
            while (i < this.count) {
                Shape s = this.painters[i].getPaintedArea();
                if (s != null) {
                    paintedArea.append(s, false);
                }
                ++i;
            }
            return paintedArea.getBounds2D();
        }
        return null;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        if (this.painters != null) {
            int i = 0;
            while (i < this.count) {
                this.painters[i].setShape(shape);
                ++i;
            }
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

