/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;

public class CMLeaf
extends CMNode {
    private QName fElement = new QName();
    private int fPosition = -1;

    final QName getElement() {
        return this.fElement;
    }

    final int getPosition() {
        return this.fPosition;
    }

    final void setPosition(int n) {
        this.fPosition = n;
    }

    boolean isNullable() throws CMException {
        return this.fPosition == -1;
    }

    String toString(StringPool stringPool) {
        StringBuffer stringBuffer = new StringBuffer(this.fElement.toString());
        stringBuffer.append(" (");
        stringBuffer.append(stringPool.toString(this.fElement.uri));
        stringBuffer.append(',');
        stringBuffer.append(stringPool.toString(this.fElement.localpart));
        stringBuffer.append(')');
        if (this.fPosition >= 0) {
            stringBuffer.append(" (Pos:" + new Integer(this.fPosition).toString() + ")");
        }
        return stringBuffer.toString();
    }

    protected void calcFirstPos(CMStateSet cMStateSet) throws CMException {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }

    protected void calcLastPos(CMStateSet cMStateSet) throws CMException {
        if (this.fPosition == -1) {
            cMStateSet.zeroBits();
        } else {
            cMStateSet.setBit(this.fPosition);
        }
    }

    public CMLeaf(QName qName, int n) throws CMException {
        super(0);
        this.fElement.setValues(qName);
        this.fPosition = n;
    }

    public CMLeaf(QName qName) throws CMException {
        super(0);
        this.fElement.setValues(qName);
    }
}

