/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDREFDatatypeValidator
extends StringDatatypeValidator {
    private static Object fNullValue = new Object();
    public static final int IDREF_VALIDATE = 0;
    public static final int IDREF_CHECKID = 1;

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
        if (stateMessageDatatype != null && stateMessageDatatype.getDatatypeState() == 1) {
            Object[] objectArray = (Object[])stateMessageDatatype.getDatatypeObject();
            this.checkIdRefs((Hashtable)objectArray[0], (Hashtable)objectArray[1]);
        } else {
            super.validate(string, object);
            if (stateMessageDatatype != null && stateMessageDatatype.getDatatypeState() == 0) {
                this.addIdRef(string, (Hashtable)stateMessageDatatype.getDatatypeObject());
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private final void addIdRef(String string, Hashtable hashtable) {
        if (hashtable.containsKey(string)) {
            return;
        }
        try {
            hashtable.put(string, fNullValue);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of Memory: Hashtable of ID's has " + hashtable.size() + " Elements");
            outOfMemoryError.printStackTrace();
        }
    }

    private final void checkIdRefs(Hashtable hashtable, Hashtable hashtable2) throws InvalidDatatypeValueException {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.containsKey(string)) continue;
            InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string);
            invalidDatatypeValueException.setMinorCode(81);
            invalidDatatypeValueException.setMajorCode(2);
            throw invalidDatatypeValueException;
        }
    }

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        if (bl) {
            return;
        }
        if (datatypeValidator != null) {
            this.setTokenType(((IDREFDatatypeValidator)datatypeValidator).fTokenType);
        } else {
            this.setTokenType("IDREF(Name)");
        }
    }
}

