/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.fop.pdf.PDFObject;

public class PDFOutline
extends PDFObject {
    private ArrayList _subentries = new ArrayList();
    private PDFOutline _parent = null;
    private PDFOutline _prev = null;
    private PDFOutline _next = null;
    private PDFOutline _first = null;
    private PDFOutline _last = null;
    private int _count = 0;
    private String _title;
    String _actionRef;

    public PDFOutline(int number, String title, String action) {
        super(number);
        this._title = title;
        this._actionRef = action;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void addOutline(PDFOutline outline) {
        if (this._subentries.size() > 0) {
            outline._prev = (PDFOutline)this._subentries.get(this._subentries.size() - 1);
            outline._prev._next = outline;
        } else {
            this._first = outline;
        }
        this._subentries.add(outline);
        outline._parent = this;
        this.incrementCount();
        this._last = outline;
    }

    private void incrementCount() {
        ++this._count;
        if (this._parent != null) {
            this._parent.incrementCount();
        }
    }

    protected byte[] toPDF() {
        StringBuffer result = new StringBuffer(String.valueOf(this.number) + " " + this.generation + " obj\n<<\n");
        if (this._parent == null) {
            if (this._first != null && this._last != null) {
                result.append(" /First " + this._first.referencePDF() + "\n");
                result.append(" /Last " + this._last.referencePDF() + "\n");
            }
        } else {
            result.append(" /Title (" + this.escapeString(this._title) + ")\n");
            result.append(" /Parent " + this._parent.referencePDF() + "\n");
            if (this._first != null && this._last != null) {
                result.append(" /First " + this._first.referencePDF() + "\n");
                result.append(" /Last " + this._last.referencePDF() + "\n");
            }
            if (this._prev != null) {
                result.append(" /Prev " + this._prev.referencePDF() + "\n");
            }
            if (this._next != null) {
                result.append(" /Next " + this._next.referencePDF() + "\n");
            }
            if (this._count > 0) {
                result.append(" /Count -" + this._count + "\n");
            }
            if (this._actionRef != null) {
                result.append(" /A " + this._actionRef + "\n");
            }
        }
        result.append(">> endobj\n");
        try {
            return result.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return result.toString().getBytes();
        }
    }

    private String escapeString(String s) {
        StringBuffer result = new StringBuffer();
        if (s != null) {
            int l = s.length();
            result.append("\\376\\377");
            int i = 0;
            while (i < l) {
                char ch = s.charAt(i);
                int high = (ch & 0xFF00) >>> 8;
                int low = ch & 0xFF;
                result.append("\\");
                result.append(Integer.toOctalString(high));
                result.append("\\");
                result.append(Integer.toOctalString(low));
                ++i;
            }
        }
        return result.toString();
    }
}

