/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.image;

import java.awt.image.Raster;
import net.sf.sqs_xml.image.RasterSource;

public class NoiseCancelFilter
extends RasterSource {
    public final int SIZE;
    public final int WHITE_THRESHOLD;
    public final int BLACK_THRESHOLD;

    public NoiseCancelFilter(RasterSource src, int size, int white, int black) {
        super(src);
        this.SIZE = size;
        this.WHITE_THRESHOLD = white;
        this.BLACK_THRESHOLD = black;
    }

    public NoiseCancelFilter(Raster raster) {
        this.SIZE = 1;
        this.WHITE_THRESHOLD = 2;
        this.BLACK_THRESHOLD = 7;
    }

    public int getRGBColor(int x, int y) {
        int target = 0;
        int numBlackPixel = 0;
        int j = -1 * this.SIZE;
        while (j <= this.SIZE) {
            int i = -1 * this.SIZE;
            while (i <= this.SIZE) {
                int color = super.getRGBColor(x + i, y + j);
                if (i == 0 && j == 0) {
                    target = color;
                } else {
                    numBlackPixel += this.isBlack(color) ? 1 : 0;
                }
                ++i;
            }
            ++j;
        }
        if (this.isBlack(target)) {
            if (numBlackPixel <= this.WHITE_THRESHOLD) {
                return 0xFFFFFF;
            }
        } else if (this.BLACK_THRESHOLD <= numBlackPixel) {
            return 0;
        }
        return target;
    }
}

