/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.DecimalFormat;
import net.sf.sqs_xml.reader.logic.ReaderTranslatedSource;
import org.apache.avalon.framework.logger.Logger;

public class ReaderLogMessage {
    static DecimalFormat format = new DecimalFormat("0.##");

    static void logImageDir(Logger logger, File imagedir) {
        logger.info("Retrieving image files from: " + imagedir.getAbsolutePath());
    }

    static void logPDFFile(Logger logger, File pdffile) {
        logger.info("Analysing PDF file: " + pdffile.getAbsolutePath());
    }

    static void logScanFrame(Logger logger, int id, String filename) {
        logger.info("file: " + id + " \"" + filename + "\"");
    }

    static void logPageError(Logger logger, Exception ex, String filename) {
        logger.error("INVALID PAGE: " + ex.getMessage() + ": " + filename);
        logger.error("##########################################");
    }

    static void logGuide(Logger logger, Point2D[] scanFrameCorner) {
        logger.debug("upper-guide-blocks: (" + scanFrameCorner[0].getX() + "," + scanFrameCorner[0].getY() + ")-(" + scanFrameCorner[1].getX() + "," + scanFrameCorner[1].getY() + ")");
        logger.debug("lower-guide-blocks: (" + scanFrameCorner[2].getX() + "," + scanFrameCorner[2].getY() + ")-(" + scanFrameCorner[3].getX() + "," + scanFrameCorner[3].getY() + ")");
    }

    static void logGuideError(Logger logger, String filename) {
        logger.error("INVALID GUIDE_BLOCK RECOGNITION: " + filename);
        logger.error("##########################################");
    }

    static void logFile(Logger logger, int pageNumber, int sampleID, String filename) {
        logger.debug("");
        if (pageNumber == 1) {
            logger.debug("");
            logger.debug("//");
            logger.info("// sampleID " + sampleID);
        }
        logger.info("= page " + pageNumber + " \"" + filename + "\"");
    }

    static void logMark(Logger logger, boolean marked, double density) {
        if (marked) {
            logger.debug("*  Filled Mark: " + format.format(density));
        } else {
            logger.debug("- not filled mark: " + format.format(density));
        }
    }

    static void logRectInfo(Logger logger, String id, Rectangle rect, ReaderTranslatedSource source) {
        Point2D o1 = source.getPoint(rect.x, rect.y, 1.0, new Point2D.Double());
        Point2D o2 = source.getPoint(rect.x + rect.width, rect.y + rect.height, 1.0, new Point2D.Double());
        logger.debug(String.valueOf(id) + " : (" + format.format(o1.getX()) + "," + format.format(o1.getY()) + ")-(" + format.format(o2.getX()) + "," + format.format(o2.getY()) + ")");
    }

    static void logCropImage(Logger logger, String imageFile) {
        logger.debug("+ crop image: " + imageFile);
    }

    static void logInvalidMark(Logger logger, int rowID, String filename, String qid, int size) {
        logger.warn("INVALID MARK in sampleID: " + rowID + " \"" + filename + "\"" + " qid:" + qid + " " + size);
        logger.warn("##########################################");
    }
}

