/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.modules;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import net.sf.sqs_xml.editor.base.modules.UpdateListener;
import net.sf.sqs_xml.editor.base.modules.UpdateTarget;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.editor.base.modules.resource.EditorResource;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.swing.IconTitledPane;
import net.sf.sqs_xml.util.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractNodeEditor
extends IconTitledPane
implements UpdateTarget {
    SourceEditorMediator mediator;
    DOMTreeSource source;
    Node node;
    EditorResource resource;
    UpdateListener updateListener;
    int prefHeight = 0;

    public AbstractNodeEditor(SourceEditorMediator mediator, DOMTreeSource source, Node node, EditorResource resource) {
        this.initialize(resource.icon, resource.title, resource.border);
        this.mediator = mediator;
        this.source = source;
        this.node = node;
        this.resource = resource;
        this.setBackground(resource.bgcolor);
        this.setLayout(new BoxLayout(this, 1));
        this.prefHeight = resource.icon.getIconHeight() + 20;
    }

    public void addPreferredHeight(int height) {
        this.prefHeight += height;
    }

    public void add(AbstractNodeEditorPanel p) {
        this.prefHeight += p.getPreferredHeight();
        super.add(p);
    }

    public SourceEditorMediator getMediator() {
        return this.mediator;
    }

    public void setMediator(SourceEditorMediator mediator) {
        this.mediator = mediator;
    }

    public void initSize() {
        this.setPreferredSize(new Dimension(200, this.prefHeight));
        this.doLayout();
    }

    public EditorResource getResource() {
        return this.resource;
    }

    public void setResource(EditorResource resource) {
        this.resource = resource;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setSource(DOMTreeSource source) {
        this.source = source;
    }

    public int getPreferredHeight() {
        return this.prefHeight;
    }

    public DOMTreeSource getSource() {
        return this.source;
    }

    public Node getNode() {
        return this.node;
    }

    public void setDirty(boolean dirty) {
        this.source.setDirty(dirty);
    }

    public boolean updateNodeValue(String xpathString, Object value) {
        if (this.source.isReadOnly()) {
            return false;
        }
        DOMUtil.setNodeValue(this.source.getDocument(), this.getNode(), xpathString, value.toString());
        return true;
    }

    public void updateAttributeValue(String xpathString, String name, String uri, Object value) {
        if (this.source.isReadOnly()) {
            return;
        }
        DOMUtil.setAttributeValue(this.source.getDocument(), (Element)this.getNode(), xpathString, name, uri, value.toString());
    }

    public int intValueOf(String xpathString, int defaultValue) {
        try {
            return DOMUtil.intValueOf(this.source.getDocument(), (Element)this.getNode(), xpathString);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public Double doubleValueOf(String xpathString) {
        try {
            return DOMUtil.doubleValueOf(this.source.getDocument(), (Element)this.getNode(), xpathString);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Double doubleValueOf(String xpathString, Double defaultValue) {
        try {
            return DOMUtil.doubleValueOf(this.source.getDocument(), (Element)this.getNode(), xpathString);
        }
        catch (NullPointerException ex) {
            return defaultValue;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public String stringValueOf(String xpathString, String defaultValue) {
        try {
            return DOMUtil.stringValueOf(this.source.getDocument(), (Element)this.getNode(), xpathString);
        }
        catch (NullPointerException ex) {
            return defaultValue;
        }
    }

    public String stringValueOf(String xpathString) {
        try {
            return DOMUtil.stringValueOf(this.source.getDocument(), (Element)this.getNode(), xpathString);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public UpdateListener getUpdateListener() {
        if (this.updateListener == null) {
            this.updateListener = new UpdateListener(this);
        }
        return this.updateListener;
    }

    public boolean updateNodeValue(boolean isUpdated) {
        if (isUpdated) {
            return this.updateNodeValue();
        }
        return false;
    }

    public boolean updateNodeValue() {
        this.source.setDirty(true);
        this.mediator.fireSourceChanged();
        return true;
    }

    public boolean isSelectableNode() {
        return this.resource.isSelectable;
    }
}

