/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.httpd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.sqs_xml.httpd.DataHandler;
import net.sf.sqs_xml.httpd.FormFilter;
import net.sf.sqs_xml.httpd.MicroHttpd;
import net.sf.sqs_xml.httpd.SQSHttpdFactory;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ViewMatrixServlet
extends HttpServlet {
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resultDir = this.getResultDir(request);
        String srcFile = request.getParameter("src");
        srcFile = srcFile == null ? "textarea.html" : srcFile;
        MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
        List matrix = this.readCSV(new File(resultDir), "MS932");
        BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        try {
            PrintWriter writer = FileUtil.createPrintWriter((OutputStream)response.getOutputStream(), "UTF-8");
            String parserClass = "org.apache.crimson.parser.XMLReaderImpl";
            XMLReader reader = XMLReaderFactory.createXMLReader(parserClass);
            FormFilter filter = new FormFilter(httpd, resultDir, "/servlet/UpdateMatrix", srcFile, matrix);
            filter.setParent(reader);
            DataHandler handler = new DataHandler(writer);
            filter.setContentHandler(handler);
            reader.setErrorHandler(handler);
            InputSource file = new InputSource(new FileInputStream(new File(String.valueOf(resultDir) + File.separator + srcFile)));
            filter.parse(file);
            writer.close();
            ((OutputStream)output).close();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    String getResultDir(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String resultDir = request.getParameter("dir");
        if (resultDir != null) {
            session.setAttribute("dir", (Object)resultDir);
        } else {
            resultDir = (String)session.getAttribute("dir");
        }
        return resultDir;
    }

    List readCSV(File resultDir, String encoding) throws ServletException, IOException {
        ArrayList ret = new ArrayList();
        File csvFile = this.getCSVFile(resultDir);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), encoding));
        String line = null;
        int columnLength = 0;
        int j = 0;
        while ((line = reader.readLine()) != null) {
            if (j == 0) {
                String[] args = line.split("\t");
                columnLength = args.length;
            }
            ArrayList<String> current = new ArrayList<String>();
            String[] args = line.split("\t");
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                current.add(StringUtil.unescape(arg));
                ++i;
            }
            i = columnLength - args.length;
            while (i >= 0) {
                current.add("");
                --i;
            }
            ret.add(current);
            ++j;
        }
        reader.close();
        return ret;
    }

    File getCSVFile(File resultDir) {
        return this.findFile(resultDir, "-csv.txt");
    }

    File findFile(File resultDir, String suffix) {
        List list = FileUtil.find(resultDir, suffix);
        if (list.size() != 1) {
            throw new RuntimeException("ERROR: folder=" + resultDir + ", suffix=" + suffix + ",  found=" + list.size() + " files.");
        }
        return (File)list.get(0);
    }

    PrintWriter getWriter(HttpServletResponse response, String encoding) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), encoding));
    }
}

