/*

 SQSHttpd.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/17

 */
package net.sf.sqs_xml.httpd;

import org.mortbay.http.HttpContext;
import org.mortbay.jetty.servlet.ServletHandler;



/**
 * @author hiroya
 *
 */
 public class MarkReaderHttpd extends MicroHttpd{
     public static final String UPDATE_URI = "/servlet/UpdateMatrix";
     public static final String VIEW_URI = "/servlet/ViewMatrix";
     
     final static Integer port = new Integer(SQSHttpdFactory.prop.getString("markreader.http.port"));
     public MarkReaderHttpd(){
         super(port.intValue());
     }

     static MarkReaderHttpd self;
     
     public static MarkReaderHttpd getSingleton(){
         if(self == null){
             synchronized(MicroHttpd.class){
                 if(self == null){
                     self = new MarkReaderHttpd();
                     SQSHttpdFactory.setInitialHttpd(self);
                 }
             }
         }
         return self;
     }

     public void addContexts() {
         super.addContexts();
         HttpContext context = new HttpContext();
         context.setContextPath("/servlet/*");
         ServletHandler servlets = new ServletHandler();
         servlets.addServlet("ViewMatrixServlet","/ViewMatrix","net.sf.sqs_xml.httpd.ViewMatrixServlet");
         servlets.addServlet("UpdateMatrixServlet","/UpdateMatrix","net.sf.sqs_xml.httpd.UpdateMatrixServlet");
         context.addHandler(servlets);
         server.addContext(context);
     }
}
