/*

 MicroHttpd.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/06

 */
package net.sf.sqs_xml.httpd;

import java.io.File;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JOptionPane;


import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
/**
 * @author hiroya
 *
 */

public class MicroHttpd {
    int port;
    HttpServer server;

    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    
    public MicroHttpd(int port) {
        try {
            this.port = port;
            this.server = new HttpServer();
            addListeners(LOOPBACK_ADDRESS, this.port);
            addContexts();
            server.start();
        } catch (Exception e) {
            System.err.println("[ERROR] Another Process may be running.");
            e.printStackTrace();
            showServerStartupErrorMessageDialog(port);
            System.exit(-1);
        }
	}
    
    public void showServerStartupErrorMessageDialog(int port) {
        JOptionPane.showMessageDialog(null, new Object[]{"[FATAL ERROR] 起動できません．", 
            	"原因：別のプロセスが起動しています(port "+port+"が占有されています)" }, "FATAL ERROR", JOptionPane.ERROR_MESSAGE);
    }

    public void addListeners(String host, int port)throws UnknownHostException {
        SocketListener listener = new SocketListener();
        listener.setHost(host);
        listener.setPort(port);
        server.addListener(listener);
    }
    
    public void addContexts() {
        addJarContext();
        addFileContexts();
        //Map map = new HashMap();
        //map.put("text/html", "UTF-8");
        //fileContext.setEncodingMap(map);
        //SetResponseHeadersHandler charsetHandler = new SetResponseHeadersHandler();
        //charsetHandler.setHeaderValue("Content-Type", "text/html; charset=UTF-8");
        //fileContext.addHandler(charsetHandler);
        //rootContext.addHandler(charsetHandler);
    }
    
    static Map mimeMap = new HashMap(); 
    static{
        mimeMap.put("html", "text/html; charset=UTF-8");
        mimeMap.put("txt", "text/plain; charset=MS932");
        mimeMap.put("tif", "image/tiff");
        mimeMap.put("jpeg", "image/jpeg");
        mimeMap.put("png", "image/png");
    }
    
    public void addFileContexts() {
        HttpContext fileContext = new HttpContext();
        fileContext.setContextPath("/File");
        ServletHandler fileServletHandler = new ServletHandler();
        fileServletHandler.addServlet("FileContentServlet", "/*",
                "net.sf.sqs_xml.httpd.FileContentServlet");
        fileContext.addHandler(fileServletHandler);
        fileContext.setMimeMap(mimeMap);
        server.addContext(fileContext);
    }

    public void addJarContext() {
        HttpContext rootContext = new HttpContext();
        rootContext.setContextPath("/");
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addServlet("JarContentServlet", "/*",
                "net.sf.sqs_xml.httpd.JarContentServlet");
        rootContext.addHandler(servletHandler);
        server.addContext(rootContext);
    }

    public String getBase(){
        return "http://"+LOOPBACK_ADDRESS+":"+port+"/";
    }
    
    /*
     * converting local file to URL served by special designed internal httpd.
     * the accessibility of sibling files of the requested file are automatically turning on.
     * @file requesting file
     * @return URL in internal httpd adressing the file
     */
    public synchronized URL getURL(File file){
        return FileContentServlet.getAltURL(getBase(), file);
    }
}
