/*

 ReaderImageProcessor.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 29, 2004

 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.AlphaComposite;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.model.ScanFrame;
import net.sf.sqs_xml.util.FileUtil;


/**
 * @author hiroya
 *
 */
public class ReaderImageProcessor {
    static AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.4f);

    static Point2D[] getPointArray(ScanFrame scanFrame){
        return new Point2D[]{
                new Point2D.Double(scanFrame.getX1(), scanFrame.getY1()), 
                new Point2D.Double(scanFrame.getX2(), scanFrame.getY2()), 
                new Point2D.Double(scanFrame.getX3(), scanFrame.getY3()), 
                new Point2D.Double(scanFrame.getX4(), scanFrame.getY4()) 
        };
    }
    

    
    /**
     * @param rect
     * @param source
     * @param imageFile
     * @throws FileNotFoundException
     * @throws IOException
     */
    static void createTextareaImage(Rectangle rect, ReaderTranslatedSource source, File imageFile) throws IOException {
        BufferedImage bufferedImage = RasterSource.createImage(source.cropRaster(rect, 2.0), false);
        FileUtil.writeImageFile(imageFile, bufferedImage);
    }

    static void drawErrorMarks(QuestionnaireSchema schema, Graphics2D g, int page, String qid, ReaderTranslatedSource tSource){
        List list = schema.getIDList(qid);
        List itemList = new LinkedList();
        Point2D[] markRectCorners = new Point2D[4];
        for (int itemIndex = 0; itemIndex < list.size(); itemIndex++) {
            String id = (String) list.get(itemIndex);
            HashMap rectMap = schema.getRectangle(page);
            Rectangle rect = (Rectangle) rectMap.get(id);
            tSource.translatePointArray(markRectCorners, rect);
            ReaderImageProcessor.drawMarkRect(g, markRectCorners);
        }
    }

    static void drawMarkRect(Graphics2D g, Point2D[] corner) {
        Composite defaultComposite = g.getComposite();
        g.setComposite(alphaComposite);
        int w = 2;
        int x0,y0,x1,y1,x2,y2,x3,y3;
        x0 = (int)corner[0].getX();
        y0 = (int)corner[0].getY();
        x1 = (int)corner[1].getX();
        y1 = (int)corner[1].getY();
        x2 = (int)corner[2].getX();
        y2 = (int)corner[3].getY();
        x3 = (int)corner[3].getX();
        y3 = (int)corner[3].getY();
    	x0 -= ReaderTranslatedSource.LEFT_EXTENT;
    	y0 -= ReaderTranslatedSource.UPPER_EXTENT;
    	x1 += ReaderTranslatedSource.RIGHT_EXTENT;
    	y1 -= ReaderTranslatedSource.UPPER_EXTENT;
    	x2 -= ReaderTranslatedSource.LEFT_EXTENT;
    	y2 += ReaderTranslatedSource.LOWER_EXTENT;
    	x3 += ReaderTranslatedSource.RIGHT_EXTENT;
    	y3 += ReaderTranslatedSource.LOWER_EXTENT;
        for (int i = -1 * w; i <= w; i++) {
            g.drawLine(x0 - i, y0 - i, x1 + i, y1 - i);
            g.drawLine(x0 - i, y0 - i, x2 - i, y2 + 1);
            g.drawLine(x1 + i, y1 - i, x3 + i, y3 + i);
            g.drawLine(x2 - i, y2 + i, x3 + i, y3 + i);
        }
        g.setComposite(defaultComposite);
    }

    static void drawScanFrameRect(BufferedImage image, Color color, ScanFrame scanFrame, int w, int h) {
        Point2D[] c = getPointArray(scanFrame);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(color);
        Composite defaultComposite = g.getComposite();
        g.setComposite(alphaComposite);
        g.fillPolygon(new int[]{0, w, w, 0, 0,
                	(int)c[0].getX(), (int)c[2].getX(),
                	(int)c[3].getX(), (int)c[1].getX(),
                	(int)c[0].getX(), 0},
                	  new int[]{0, 0, h, h, 0,
                	(int)c[0].getY(), (int)c[2].getY(),
                	(int)c[3].getY(), (int)c[1].getY(),
                	(int)c[0].getY(), 0}, 11);
        g.setComposite(defaultComposite);
        g.setComposite(defaultComposite);
    }
}
