/*

 FileUploadReceiver.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 30, 2004

 */
package net.sf.sqs_xml.translator.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import net.sf.sqs_xml.util.StringUtil;

import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

/**
 * @author hiroya
 *
 */
public class FileUploadReceiver {
	/**
     * @param req
     * @param res
     * @throws ServletException
     * @throws IOException
     */
    static public UploadedFile receiveFileUpload(HttpServletRequest req, HttpServletResponse res,
            String fileParamName) throws ServletException, IOException {
        /*
		if (! FileUploadBase.isMultipartContent(req)) {
			String xmlurl = req.getParameter("sqs");
			String fileNameBody = logic.createFileNameBody("sqs");
			req.setAttribute("fileNameBody", fileNameBody);
			req.setAttribute("source", logic.createSource(xmlurl));
		}
		*/
		try {
			DiskFileUpload fu = createDiskFileUpload();
			File tmpdir = createTmpDirectory();
			fu.setRepositoryPath(tmpdir.getAbsolutePath());
			List fileItems = fu.parseRequest(req);
			Iterator it = fileItems.iterator();
			while (it.hasNext()) {
				FileItem item = (FileItem) it.next();
				if (! item.isFormField()) {
					String fieldName = item.getFieldName();
					String fileName = item.getName();
					String fileNameBody =
						StringUtil.chop(new File(fileName).getName(), ".");
					//String contentType = item.getContentType();
					//boolean isInMemory = item.isInMemory();
					//long sizeInBytes = item.getSize();
					if (fileParamName.equals(fieldName)) {
						if(item.getSize()==0){
							throw new FileNotFoundException(fileName);
						}
						return new UploadedFile(fileNameBody, item.getInputStream());
					}
				}
			}
		} catch (FileUploadException e) {
			throw new ServletException(e);
		} catch (FileNotFoundException e) {
			responseErrorMessage(res);
			throw new ServletException(e);
		} catch (IOException e) {
		    throw new ServletException(e);
		}
		throw new ServletException();
    }

    /**
     * @param res
     * @throws IOException
     */
    private static void responseErrorMessage(HttpServletResponse res) throws IOException {
        res.setContentType("text/plain");
        PrintWriter writer = new PrintWriter(res.getWriter());
        writer.println("File Not Found or File Length is zero.");
        writer.close();
    }

    /**
     * @return
     */
    private static File createTmpDirectory() {
        File tmpdir =
        	new File(
        System.getProperty("java.io.tmpdir", "/tmp")
        			+ File.separator
        			+ "uploadfile");
        if (!tmpdir.exists()) {
        	tmpdir.mkdirs();
        }
        return tmpdir;
    }

    /**
     * @return
     */
    private static DiskFileUpload createDiskFileUpload() {
        DiskFileUpload fu = new DiskFileUpload();
        fu.setSizeThreshold(65546);
        fu.setSizeMax(1000000);
        return fu;
    }
}
