/*

 NodeAwareSchemaParser.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/12

 */
package org.kohsuke.rngom.parse.xml;

import org.kohsuke.rngom.ast.builder.IncludedGrammar;
import org.kohsuke.rngom.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.ast.builder.Scope;
import org.kohsuke.rngom.ast.util.NodeLocator;
import org.kohsuke.rngom.ast.util.NodeLocatorImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/**
 * @author hiroya
 *
 */
public class NodeAwareSchemaParser extends SchemaParser {

    /**
     * @param parseable
     * @param xr
     * @param eh
     * @param schemaBuilder
     * @param grammar
     * @param scope
     * @param inheritedNs
     * @throws SAXException
     */
    public NodeAwareSchemaParser(SAXParseable parseable, XMLReader xr,
            ErrorHandler eh, SchemaBuilder schemaBuilder,
            IncludedGrammar grammar, Scope scope, String inheritedNs)
            throws SAXException {
        super(parseable, xr, eh, schemaBuilder, grammar, scope, inheritedNs);
        // TODO Auto-generated constructor stub
    }
    
    private NodeLocator makeNodeAwareLocation() {
        return new NodeLocatorImpl((Locator)makeLocation(), null);//TODO: Location? Locator?
    }

    
}
