#! /bin/sh
#
# Shell script to run SQS_CORE_HOME, adapted from the Jakarta-Ant project.

if [ -f $HOME/.sqsrc ] ; then 
  . $HOME/.sqsrc
fi

# OS specific support.  $var _must_ be set to either true or false.
cygwin=false;
darwin=false;
case "`uname`" in
  CYGWIN*) cygwin=true ;;
  Darwin*) darwin=true ;;
esac

if [ -z "$SQS_CORE_HOME" ] ; then
  # try to find SQS_CORE
  if [ -d /opt/sqs_core ] ; then 
    SQS_CORE_HOME=/opt/sqs_core
  fi

  if [ -d ${HOME}/opt/sqs_core ] ; then 
    SQS_CORE_HOME=${HOME}/opt/sqs_core
  fi

  ## resolve links - $0 may be a link to sqs_core's home
  PRG=$0
  progname=`basename $0`
  
  while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '.*/.*' > /dev/null; then
	PRG="$link"
    else
	PRG="`dirname $PRG`/$link"
    fi
  done
  
  SQS_CORE_HOME=`dirname "$PRG"`

fi

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin ; then
  [ -n "$SQS_CORE_HOME" ] &&
    SQS_CORE_HOME=`cygpath --unix "$SQS_CORE_HOME"`
  [ -n "$JAVA_HOME" ] &&
    JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
  [ -n "$CLASSPATH" ] &&
    CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

if [ -z "$JAVACMD" ] ; then 
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then 
      # IBM's JDK on AIX uses strange locations for the executables
      JAVACMD=$JAVA_HOME/jre/sh/java
    else
      JAVACMD=$JAVA_HOME/bin/java
    fi
  else
    JAVACMD=java
  fi
fi
 
if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit
fi

if [ -n "$CLASSPATH" ] ; then
  LOCALCLASSPATH=$CLASSPATH
fi

# add sqs_core.jar, which resides in $SQS_CORE_HOME/build
LOCALCLASSPATH=${JAVA_HOME}/jre/javaws/javaws.jar:$LOCALCLASSPATH

# add in the dependency .jar files, which reside in $SQS_CORE_HOME/lib
DIRLIBS=${SQS_CORE_HOME}/app/lib/*.jar
for i in ${DIRLIBS}
do
    # if the directory is empty, then it will return the input string
    # this is stupid, so case for it
    if [ "$i" != "${DIRLIBS}" ] ; then
      if [ -z "$LOCALCLASSPATH" ] ; then
        LOCALCLASSPATH=$i
      else
        LOCALCLASSPATH="$i":$LOCALCLASSPATH
      fi
    fi
done

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
  SQS_CORE_HOME=`cygpath --path --windows "$SQS_CORE_HOME"`
  JAVA_HOME=`cygpath --path --windows "$JAVA_HOME"`
  LOCALCLASSPATH=`cygpath --path --windows "$LOCALCLASSPATH"`
fi

$JAVACMD -classpath "$LOCALCLASSPATH" $SQS_CORE_OPTS net.sf.sqs_xml.reader.swing.MarkReader "$@"

