<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" xmlns:xalan="http://xml.apache.org/xalan" version="1.0" exclude-result-prefixes="xalan xforms sqs">
	<xsl:template match="xforms:input|xforms:textarea">
		<xsl:element name="xforms:textarea">
			<xsl:apply-templates select="@xforms:*|@sqs:*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xforms:select|xforms:select1">
		<xsl:choose>
			<xsl:when test="@sqs:pxform-type = 'range'">
				<xsl:call-template name="layout-range"/>
			</xsl:when>
			<xsl:when test="@sqs:pxform-type = 'matrix-forms'">
				<xsl:call-template name="matrix-forms-column-set-select">
					<xsl:with-param name="local-name">
						<xsl:value-of select="local-name()"/>
					</xsl:with-param>
					<xsl:with-param name="ref">
						<xsl:value-of select="@xforms:ref"/>
					</xsl:with-param>
					<xsl:with-param name="label">
						<xsl:value-of select="xforms:label"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="convert-select-schema">
					<xsl:with-param name="local-name">
						<xsl:value-of select="local-name()"/>
					</xsl:with-param>
					<xsl:with-param name="ref">
						<xsl:value-of select="@xforms:ref"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="xforms:label">
		<xsl:for-each select="xforms:label">
			<xsl:apply-templates/>
		</xsl:for-each>
	</xsl:template>
	<!-- ###################################### -->
	<xsl:template name="matrix-forms-column-set-select">
		<xsl:param name="local-name"/>
		<xsl:param name="ref"/>
		<xsl:param name="label"/>
<!--
		<xhtml2:table>
		<xhtml2:tr>
-->
	<xsl:variable name="column-start"><xsl:choose><xsl:when test="position()=1">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:variable>

		<xsl:for-each select="xforms:item">
			<xsl:variable name="column-start"><xsl:choose><xsl:when test="position()=1">true</xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:variable>

		<xhtml2:td xhtml2:class='matrix-forms-column-set' sqs:column-start="{$column-start}">
															<xsl:call-template name="select-item-to-single-select">
																<xsl:with-param name="local-name">
																	<xsl:value-of select="$local-name"/>
																</xsl:with-param>
																<xsl:with-param name="ref">
																	<xsl:value-of select="$ref"/>
																</xsl:with-param>
																<xsl:with-param name="label">
																	<xsl:value-of select="$label"/>
																</xsl:with-param>
															</xsl:call-template>
		</xhtml2:td>
		</xsl:for-each>
<!--
		</xhtml2:tr>
		</xhtml2:table>
-->
	</xsl:template>

	<xsl:template name="normalize-containing-item">
		<xsl:element name="xforms:select">
			<xsl:attribute name="sqs:cols"><xsl:choose><xsl:when test="0 &lt; string-length(@sqs:cols)"><xsl:value-of select="@sqs:cols"/></xsl:when><xsl:otherwise><xsl:value-of select="count(xforms:item)"/></xsl:otherwise></xsl:choose></xsl:attribute>
			<xforms:label>
				<xsl:call-template name="xforms:label"/>
			</xforms:label>
			<xsl:for-each select="xforms:item">
				<xsl:variable name="colspan">
					<xsl:choose>
						<xsl:when test="0 &lt; string-length(@sqs:colspan)">
							<xsl:value-of select="@sqs:colspan"/>
						</xsl:when>
						<xsl:otherwise>1</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:element name="xforms:item">
					<xsl:attribute name="sqs:colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
					<xsl:for-each select="xforms:label|xforms:value">
						<xsl:copy-of select="."/>
					</xsl:for-each>
				</xsl:element>
				<xsl:if test="1 &lt; $colspan">
					<xsl:call-template name="xsl-function-loop">
						<xsl:with-param name="times">
							<xsl:value-of select="$colspan - 1"/>
						</xsl:with-param>
						<xsl:with-param name="value">
							<xforms:item sqs:colspan="0"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<!-- ###################################################################### -->
	<xsl:template name="convert-select-schema">
		<xsl:param name="local-name"/>
		<xsl:param name="ref"/>
		<xsl:variable name="span"><xsl:choose>
			<xsl:when test="0 &lt; string-length(@sqs:cols)"><xsl:value-of select="@sqs:cols"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="count(xforms:item)"/></xsl:otherwise>
		</xsl:choose></xsl:variable>
		<xsl:variable name="contents">
			<xsl:call-template name="normalize-containing-item"/>
		</xsl:variable>
		<xsl:for-each select="xalan:nodeset($contents)//xforms:select">
			<xsl:variable name="label">
				<xsl:value-of select="xforms:label"/>
			</xsl:variable>
			<xhtml2:table xhtml2:class="itemset" sqs:cols="{$span}">
				<xhtml2:tbody>
					<xsl:for-each select="xforms:item">
						<xsl:if test="(position()-1) mod ($span) = 0">
							<xsl:variable name="colspan">
								<xsl:choose>
									<xsl:when test="0 &lt; string-length(@sqs:colspan)">
										<xsl:value-of select="@sqs:colspan"/>
									</xsl:when>
									<xsl:otherwise>1</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xhtml2:tr>
								<xsl:for-each select=".|following-sibling::xforms:item[position() &lt; $span]">
									<xsl:if test="0 &lt; number(@sqs:colspan)">
										<xhtml2:td xhtml2:style="width:{100 * number(@sqs:colspan) div $span}%" xhtml2:colspan="{@sqs:colspan}">
											<xhtml2:table xhtml2:class="item">
												<xhtml2:tbody>
													<xhtml2:tr>
														<xhtml2:td xhtml2:class="item-form">
															<xsl:call-template name="select-item-to-single-select">
																<xsl:with-param name="local-name">
																	<xsl:value-of select="$local-name"/>
																</xsl:with-param>
																<xsl:with-param name="ref">
																	<xsl:value-of select="$ref"/>
																</xsl:with-param>
																<xsl:with-param name="label">
																	<xsl:value-of select="$label"/>
																</xsl:with-param>
															</xsl:call-template>
														</xhtml2:td>
														<xhtml2:td xhtml2:class="item-value">
															<xsl:value-of select="xforms:value"/>:
                      </xhtml2:td>
														<xhtml2:td xhtml2:class="item-label">
															<xsl:call-template name="xforms:label"/>
														</xhtml2:td>
													</xhtml2:tr>
												</xhtml2:tbody>
											</xhtml2:table>
										</xhtml2:td>
									</xsl:if>
								</xsl:for-each>
							</xhtml2:tr>
						</xsl:if>
					</xsl:for-each>
				</xhtml2:tbody>
			</xhtml2:table>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="select-item-to-single-select">
		<xsl:param name="local-name"/>
		<xsl:param name="ref"/>
		<xsl:param name="label"/>
		<xforms:select xforms:ref="{$ref}/v{xforms:value}" sqs:pxform-type="{$local-name}">
			<xforms:label>
				<xsl:value-of select="$label"/>
			</xforms:label>
			<xforms:item>
				<xforms:label>
					<xsl:value-of select="xforms:label"/>
				</xforms:label>
				<xforms:value>
					<xsl:value-of select="xforms:value"/>
				</xforms:value>
			</xforms:item>
		</xforms:select>
	</xsl:template>
	<!-- ######################### -->
	<xsl:template match="xhtml2:td[@xhtml2:class='matrix-forms-column-set']">
		<xsl:for-each select="xforms:select|xforms:select1">
				<xsl:call-template name="matrix-forms-column-set-select">
					<xsl:with-param name="local-name">
						<xsl:value-of select="local-name()"/>
					</xsl:with-param>
					<xsl:with-param name="ref">
						<xsl:value-of select="@xforms:ref"/>
					</xsl:with-param>
					<xsl:with-param name="label">
						<xsl:value-of select="xforms:label"/>
					</xsl:with-param>
				</xsl:call-template>
		<xsl:text>
</xsl:text>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
