/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    private float cellpadding;
    private float cellspacing;

    PdfTable(Table table, float left, float right, float top) {
        super(left, top, right, top);
        PdfCell currentCell;
        int i;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.columns = table.columns();
        this.cellpadding = table.cellpadding();
        this.cellspacing = table.cellspacing();
        float[] positions = table.getWidths(left, right - left);
        this.setLeft(positions[0]);
        this.setRight(positions[positions.length - 1]);
        int rowNumber = 0;
        int groupNumber = 0;
        int firstDataRow = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int rows = table.size() + 1;
        float[] offsets = new float[rows];
        int i2 = 0;
        while (i2 < rows) {
            offsets[i2] = top;
            ++i2;
        }
        Iterator rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            boolean groupChange = false;
            Row row = (Row)rowIterator.next();
            if (row.isEmpty()) {
                if (rowNumber < rows - 1 && offsets[rowNumber + 1] > offsets[rowNumber]) {
                    offsets[rowNumber + 1] = offsets[rowNumber];
                }
            } else {
                i = 0;
                while (i < row.columns()) {
                    Cell cell = (Cell)row.getCell(i);
                    if (cell != null) {
                        block14: {
                            currentCell = new PdfCell(cell, rowNumber, positions[i], positions[i + cell.colspan()], offsets[rowNumber], this.cellspacing, this.cellpadding);
                            try {
                                if (offsets[rowNumber] - currentCell.height() - this.cellpadding < offsets[rowNumber + currentCell.rowspan()]) {
                                    offsets[rowNumber + currentCell.rowspan()] = offsets[rowNumber] - currentCell.height() - this.cellpadding;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException aioobe) {
                                if (!(offsets[rowNumber] - currentCell.height() < offsets[rows - 1])) break block14;
                                offsets[rows - 1] = offsets[rowNumber] - currentCell.height();
                            }
                        }
                        if (rowNumber < firstDataRow) {
                            currentCell.setHeader();
                            this.headercells.add(currentCell);
                        }
                        currentCell.setGroupNumber(groupNumber);
                        groupChange |= cell.getGroupChange();
                        this.cells.add(currentCell);
                    }
                    ++i;
                }
            }
            ++rowNumber;
            if (!groupChange) continue;
            ++groupNumber;
        }
        int n = this.cells.size();
        i = 0;
        while (i < n) {
            currentCell = (PdfCell)this.cells.get(i);
            try {
                currentCell.setBottom(offsets[currentCell.rownumber() + currentCell.rowspan()]);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                currentCell.setBottom(offsets[rows - 1]);
            }
            ++i;
        }
        this.setBottom(offsets[rows - 1]);
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    float cellpadding() {
        return this.cellpadding;
    }

    float cellspacing() {
        return this.cellspacing;
    }
}

