/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    static final byte[] endobj = new byte[]{101, 110, 100, 111, 98, 106};
    protected PRTokeniser tokens;
    protected int[] xref;
    protected PdfObject[] xrefObj;
    protected PdfDictionary trailer;
    protected PdfDictionary[] pages;
    protected PdfDictionary catalog;
    protected PRIndirectReference[] pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected ArrayList pageInh;
    protected int pagesCount;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int objNum;
    private int objGen;
    private boolean[] visited;
    private IntHashtable newHits;

    protected PdfReader() {
    }

    public PdfReader(String filename) throws IOException {
        this(filename, null);
    }

    public PdfReader(String filename, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(filename);
        this.readPdf();
    }

    public PdfReader(byte[] pdfIn) throws IOException {
        this(pdfIn, null);
    }

    public PdfReader(byte[] pdfIn, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(pdfIn);
        this.readPdf();
    }

    public PdfReader(URL url) throws IOException {
        this(url, null);
    }

    public PdfReader(URL url, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(url));
        this.readPdf();
    }

    public PdfReader(PdfReader reader) {
        this.consolidateNamedDestinations = reader.consolidateNamedDestinations;
        this.encrypted = reader.encrypted;
        this.rebuilt = reader.rebuilt;
        this.sharedStreams = reader.sharedStreams;
        this.tampered = reader.tampered;
        this.password = reader.password;
        this.pdfVersion = reader.pdfVersion;
        this.eofPos = reader.eofPos;
        this.freeXref = reader.freeXref;
        this.lastXref = reader.lastXref;
        this.pagesCount = reader.pagesCount;
        this.tokens = reader.tokens;
        this.decrypt = reader.decrypt;
        this.pValue = reader.pValue;
        this.rValue = reader.rValue;
        this.xrefObj = new PdfObject[reader.xrefObj.length];
        int k = 0;
        while (k < reader.xrefObj.length) {
            this.xrefObj[k] = PdfReader.duplicatePdfObject(reader.xrefObj[k], this);
            ++k;
        }
        this.pageRefs = new PRIndirectReference[reader.pageRefs.length];
        this.pages = new PdfDictionary[reader.pages.length];
        k = 0;
        while (k < reader.pageRefs.length) {
            this.pageRefs[k] = (PRIndirectReference)PdfReader.duplicatePdfObject(reader.pageRefs[k], this);
            this.pages[k] = (PdfDictionary)PdfReader.getPdfObject(this.pageRefs[k]);
            ++k;
        }
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(reader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter writer) {
        return new PdfReaderInstance(this, writer, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject form = this.catalog.get(PdfName.ACROFORM);
            if (form != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(form));
                }
                catch (Exception e) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfNumber rotate = (PdfNumber)PdfReader.getPdfObject(page.get(PdfName.ROTATE));
        if (rotate == null) {
            return 0;
        }
        int n = rotate.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public Rectangle getPageSizeWithRotation(int index) {
        Rectangle rect = this.getPageSize(index);
        int rotation = this.getPageRotation(index);
        while (rotation > 0) {
            rect = rect.rotate();
            rotation -= 90;
        }
        return rect;
    }

    public Rectangle getPageSize(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfArray mediaBox = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(mediaBox);
    }

    public Rectangle getCropBox(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfArray cropBox = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.CROPBOX));
        if (cropBox == null) {
            return this.getPageSize(index);
        }
        return PdfReader.getNormalizedRectangle(cropBox);
    }

    public HashMap getInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        PdfDictionary info = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (info == null) {
            return map;
        }
        Iterator it = info.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject obj = PdfReader.getPdfObject(info.get(key));
            if (obj == null) continue;
            String value = obj.toString();
            switch (obj.type()) {
                case 3: {
                    value = ((PdfString)obj).toUnicodeString();
                    break;
                }
                case 4: {
                    value = PdfName.decodeName(value);
                }
            }
            map.put(PdfName.decodeName(key.toString()), value);
        }
        return map;
    }

    public static Rectangle getNormalizedRectangle(PdfArray box) {
        ArrayList rect = box.getArrayList();
        float llx = ((PdfNumber)rect.get(0)).floatValue();
        float lly = ((PdfNumber)rect.get(1)).floatValue();
        float urx = ((PdfNumber)rect.get(2)).floatValue();
        float ury = ((PdfNumber)rect.get(3)).floatValue();
        return new Rectangle(Math.min(llx, urx), Math.min(lly, ury), Math.max(llx, urx), Math.max(lly, ury));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPdf() throws IOException {
        try {
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception e) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception ne) {
                    throw new IOException("Rebuild failed: " + ne.getMessage() + "; Original message: " + e.getMessage());
                }
            }
            this.readDocObj();
            this.readDecryptedDocObj();
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this.tokens.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception e) {
            return;
        }
        this.tokens.close();
    }

    private boolean equalsArray(byte[] ar1, byte[] ar2, int size) {
        int k = 0;
        while (k < size) {
            if (ar1[k] != ar2[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        String s;
        PdfObject o;
        PdfObject encDic = this.trailer.get(PdfName.ENCRYPT);
        if (encDic == null || encDic.toString().equals("null")) {
            return;
        }
        this.encrypted = true;
        PdfDictionary enc = (PdfDictionary)PdfReader.getPdfObject(encDic);
        PdfArray documentIDs = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] documentID = null;
        if (documentIDs != null) {
            o = (PdfObject)documentIDs.getArrayList().get(0);
            s = o.toString();
            documentID = DocWriter.getISOBytes(s);
        }
        s = enc.get(PdfName.U).toString();
        byte[] uValue = DocWriter.getISOBytes(s);
        s = enc.get(PdfName.O).toString();
        byte[] oValue = DocWriter.getISOBytes(s);
        o = enc.get(PdfName.R);
        if (!o.isNumber()) {
            throw new IOException("Illegal R value.");
        }
        this.rValue = ((PdfNumber)o).intValue();
        if (this.rValue != 2 && this.rValue != 3) {
            throw new IOException("Unknown encryption type (" + this.rValue + ")");
        }
        o = enc.get(PdfName.P);
        if (!o.isNumber()) {
            throw new IOException("Illegal P value.");
        }
        this.pValue = ((PdfNumber)o).intValue();
        this.decrypt = new PdfEncryption();
        this.decrypt.setupByUserPassword(documentID, this.password, oValue, this.pValue, this.rValue == 3);
        if (!this.equalsArray(uValue, this.decrypt.userKey, this.rValue == 3 ? 16 : 32)) {
            this.decrypt.setupByOwnerPassword(documentID, this.password, uValue, oValue, this.pValue, this.rValue == 3);
            if (!Arrays.equals(uValue, this.decrypt.userKey)) {
                throw new IOException("Bad user password");
            }
        }
        int k = 0;
        while (k < this.strings.size()) {
            PdfString str = (PdfString)this.strings.get(k);
            str.decrypt(this);
            ++k;
        }
        if (encDic.isIndirect()) {
            this.xrefObj[((PRIndirectReference)encDic).getNumber()] = null;
        }
    }

    public static PdfObject getPdfObject(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (!obj.isIndirect()) {
            return obj;
        }
        PRIndirectReference ref = (PRIndirectReference)obj;
        int idx = ref.getNumber();
        if ((obj = ref.getReader().xrefObj[idx]) == null) {
            return PdfNull.PDFNULL;
        }
        return obj;
    }

    protected void pushPageAttributes(PdfDictionary nodePages) {
        PdfDictionary dic = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            dic.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        int k = 0;
        while (k < pageInhCandidates.length) {
            PdfObject obj = nodePages.get(pageInhCandidates[k]);
            if (obj != null) {
                dic.put(pageInhCandidates[k], obj);
            }
            ++k;
        }
        this.pageInh.add(dic);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PdfDictionary page) throws IOException {
        PdfArray kidsPR = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.KIDS));
        if (kidsPR == null) {
            page.put(PdfName.TYPE, PdfName.PAGE);
            PdfDictionary dic = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Iterator i = dic.getKeys().iterator();
            while (i.hasNext()) {
                PdfName key = (PdfName)i.next();
                if (page.get(key) != null) continue;
                page.put(key, dic.get(key));
            }
            if (page.get(PdfName.MEDIABOX) == null) {
                PdfArray arr = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.right(), PageSize.LETTER.top()});
                page.put(PdfName.MEDIABOX, arr);
            }
            this.pages[this.pagesCount++] = page;
        } else {
            page.put(PdfName.TYPE, PdfName.PAGES);
            this.pushPageAttributes(page);
            ArrayList kids = kidsPR.getArrayList();
            int k = 0;
            while (k < kids.size()) {
                this.pageRefs[this.pagesCount] = (PRIndirectReference)kids.get(k);
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObject(this.pageRefs[this.pagesCount]);
                this.iteratePages(kid);
                ++k;
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        PdfNumber count = (PdfNumber)PdfReader.getPdfObject(rootPages.get(PdfName.COUNT));
        this.pages = new PdfDictionary[count.intValue()];
        this.pageRefs = new PRIndirectReference[this.pages.length];
        this.pagesCount = 0;
        this.iteratePages(rootPages);
        this.pageInh = null;
    }

    protected void PRSimpleRecursive(PdfObject obj) throws IOException {
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    PdfName key = (PdfName)it.next();
                    this.PRSimpleRecursive(dic.get(key));
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                int k = 0;
                while (k < list.size()) {
                    this.PRSimpleRecursive((PdfObject)list.get(k));
                    ++k;
                }
                break;
            }
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)obj;
                int num = ref.getNumber();
                if (this.visited[num]) break;
                this.visited[num] = true;
                this.newHits.put(num, 1);
            }
        }
    }

    protected void readDocObj() throws IOException {
        ArrayList<PdfObject> streams = new ArrayList<PdfObject>();
        this.xrefObj = new PdfObject[this.xref.length];
        this.visited = new boolean[this.xref.length];
        this.newHits = new IntHashtable();
        this.PRSimpleRecursive(this.trailer);
        while (!this.newHits.isEmpty()) {
            int[] hits = this.newHits.getKeys();
            this.newHits.clear();
            int k = 0;
            while (k < hits.length) {
                int pos = this.xref[hits[k]];
                if (pos > 0) {
                    PdfObject obj;
                    this.tokens.seek(pos);
                    this.tokens.nextValidToken();
                    if (this.tokens.getTokenType() != 1) {
                        this.tokens.throwError("Invalid object number.");
                    }
                    this.objNum = this.tokens.intValue();
                    this.tokens.nextValidToken();
                    if (this.tokens.getTokenType() != 1) {
                        this.tokens.throwError("Invalid generation number.");
                    }
                    this.objGen = this.tokens.intValue();
                    this.tokens.nextValidToken();
                    if (!this.tokens.getStringValue().equals("obj")) {
                        this.tokens.throwError("Token 'obj' expected.");
                    }
                    this.xrefObj[hits[k]] = obj = this.readPRObject();
                    if (obj.isStream()) {
                        streams.add(obj);
                    }
                }
                ++k;
            }
        }
        this.visited = null;
        this.newHits = null;
        int fileLength = this.tokens.length();
        byte[] tline = new byte[16];
        int k = 0;
        while (k < streams.size()) {
            int streamLength;
            PRStream stream;
            block14: {
                stream = (PRStream)streams.get(k);
                PdfNumber length = (PdfNumber)PdfReader.getPdfObject(stream.get(PdfName.LENGTH));
                int start = stream.getOffset();
                streamLength = length.intValue();
                boolean calc = false;
                if (streamLength + start > fileLength - 20) {
                    calc = true;
                } else {
                    this.tokens.seek(start + streamLength);
                    String line = this.tokens.readString(20);
                    if (!(line.startsWith("\nendstream") || line.startsWith("\r\nendstream") || line.startsWith("\rendstream") || line.startsWith("endstream"))) {
                        calc = true;
                    }
                }
                if (calc) {
                    int pos;
                    this.tokens.seek(start);
                    do {
                        pos = this.tokens.getFilePointer();
                        if (!this.tokens.readLineSegment(tline)) break block14;
                        if (!PdfReader.equalsn(tline, endstream)) continue;
                        streamLength = pos - start;
                        break block14;
                    } while (!PdfReader.equalsn(tline, endobj));
                    this.tokens.seek(pos - 16);
                    String s = this.tokens.readString(16);
                    int index = s.indexOf("endstream");
                    if (index >= 0) {
                        pos = pos - 16 + index;
                    }
                    streamLength = pos - start;
                }
            }
            stream.setLength(streamLength);
            ++k;
        }
        this.xref = null;
    }

    static PdfObject killIndirect(PdfObject obj) {
        if (obj == null || obj.isNull()) {
            return null;
        }
        PdfObject ret = PdfReader.getPdfObject(obj);
        if (obj.isIndirect()) {
            PRIndirectReference ref = (PRIndirectReference)obj;
            ref.getReader().xrefObj[ref.getNumber()] = null;
        }
        return ret;
    }

    protected void readXref() throws IOException {
        PdfNumber prev;
        int ch;
        int startxref;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = startxref = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        this.tokens.seek(startxref);
        while ((ch = this.tokens.read()) != -1 && ch != 116) {
        }
        if (ch == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition(ch);
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PdfDictionary)this.readPRObject();
        PdfNumber xrefSize = (PdfNumber)this.trailer.get(PdfName.SIZE);
        this.xref = new int[xrefSize.intValue()];
        this.tokens.seek(startxref);
        this.readXrefSection();
        PdfDictionary trailer2 = this.trailer;
        while ((prev = (PdfNumber)trailer2.get(PdfName.PREV)) != null) {
            this.tokens.seek(prev.intValue());
            this.readXrefSection();
            trailer2 = (PdfDictionary)this.readPRObject();
        }
    }

    protected void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int start = 0;
        int end = 0;
        int pos = 0;
        int gen = 0;
        block0: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            start = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            end = this.tokens.intValue() + start;
            if (start == 1) {
                int back = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                if (pos == 0 && gen == 65535) {
                    --start;
                    --end;
                }
                this.tokens.seek(back);
            }
            if (this.xref.length < end) {
                int[] xref2 = new int[end];
                System.arraycopy(this.xref, 0, xref2, 0, this.xref.length);
                this.xref = xref2;
            }
            int k = start;
            while (true) {
                if (k >= end) continue block0;
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[k] == 0) {
                        if (pos == 0) {
                            this.tokens.throwError("File position 0 cross-reference entry in this xref subsection");
                        }
                        this.xref[k] = pos;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[k] == 0) {
                        this.xref[k] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++k;
            }
            break;
        }
    }

    protected void rebuildXref() throws IOException {
        int[] obj;
        this.tokens.seek(0);
        int[][] xr = new int[1024][];
        int top = 0;
        this.trailer = null;
        byte[] line = new byte[64];
        while (true) {
            int pos = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(line)) break;
            if (line[0] == 116) {
                if (!PdfEncodings.convertToString(line, null).startsWith("trailer")) continue;
                pos = this.tokens.getFilePointer();
                try {
                    PdfDictionary dic = (PdfDictionary)this.readPRObject();
                    if (dic.get(PdfName.ROOT) != null) {
                        this.trailer = dic;
                        continue;
                    }
                    this.tokens.seek(pos);
                }
                catch (Exception e) {
                    this.tokens.seek(pos);
                }
                continue;
            }
            if (line[0] < 48 || line[0] > 57 || (obj = PRTokeniser.checkObjectStart(line)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            if (num >= xr.length) {
                int newLength = num * 2;
                int[][] xr2 = new int[newLength][];
                System.arraycopy(xr, 0, xr2, 0, top);
                xr = xr2;
            }
            if (num >= top) {
                top = num + 1;
            }
            if (xr[num] != null && gen < xr[num][1]) continue;
            obj[0] = pos;
            xr[num] = obj;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[top];
        int k = 0;
        while (k < top) {
            obj = xr[k];
            if (obj != null) {
                this.xref[k] = obj[0];
            }
            ++k;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName name = new PdfName(this.tokens.getStringValue());
            PdfObject obj = this.readPRObject();
            int type = obj.type();
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-type == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject obj;
        int type;
        PdfArray array = new PdfArray();
        while (-(type = (obj = this.readPRObject()).type()) != 6) {
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            array.add(obj);
        }
        return array;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int type = this.tokens.getTokenType();
        switch (type) {
            case 7: {
                PdfDictionary dic = this.readDictionary();
                int pos = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int ch = this.tokens.read();
                    if (ch == 13) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    PRStream stream = new PRStream(this, this.tokens.getFilePointer());
                    stream.putAll(dic);
                    stream.setObjNum(this.objNum, this.objGen);
                    return stream;
                }
                this.tokens.seek(pos);
                return dic;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString str = new PdfString(this.tokens.getStringValue(), null).setWritingMode(this.tokens.isHexString());
                str.setObjNum(this.objNum, this.objGen);
                this.strings.add(str);
                return str;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                int num = this.tokens.getReference();
                PRIndirectReference ref = new PRIndirectReference(this, num, this.tokens.getGeneration());
                if (this.visited != null && !this.visited[num]) {
                    this.visited[num] = true;
                    this.newHits.put(num, 1);
                }
                return ref;
            }
        }
        return new PdfLiteral(-type, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] in) {
        byte[] b = PdfReader.FlateDecode(in, true);
        if (b == null) {
            return PdfReader.FlateDecode(in, false);
        }
        return b;
    }

    public static byte[] FlateDecode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        int n1 = 0;
        int k = 0;
        while (k < in.length) {
            int ch = in[k] & 0xFF;
            if (ch == 62) break;
            if (!PRTokeniser.isWhitespace(ch)) {
                int n = PRTokeniser.getHex(ch);
                if (n == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (first) {
                    n1 = n;
                } else {
                    out.write((byte)((n1 << 4) + n));
                }
                first = !first;
            }
            ++k;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int state = 0;
        int[] chn = new int[5];
        int k = 0;
        while (k < in.length) {
            int ch = in[k] & 0xFF;
            if (ch == 126) break;
            if (!PRTokeniser.isWhitespace(ch)) {
                if (ch == 122 && state == 0) {
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                } else {
                    if (ch < 33 || ch > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    chn[state] = ch - 33;
                    if (++state == 5) {
                        state = 0;
                        int r = 0;
                        int j = 0;
                        while (j < 5) {
                            r = r * 85 + chn[j];
                            ++j;
                        }
                        out.write((byte)(r >> 24));
                        out.write((byte)(r >> 16));
                        out.write((byte)(r >> 8));
                        out.write((byte)r);
                    }
                }
            }
            ++k;
        }
        int r = 0;
        if (state == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (state == 2) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85;
            out.write((byte)(r >> 24));
        } else if (state == 3) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
        } else if (state == 4) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + chn[3] * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
        }
        return out.toByteArray();
    }

    public static byte[] LZWDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LZWDecoder lzw = new LZWDecoder();
        lzw.decode(in, out);
        return out.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int pageNum) {
        if (pageNum > this.pages.length) {
            return null;
        }
        return this.pages[pageNum - 1];
    }

    public PRIndirectReference getPageOrigRef(int pageNum) {
        if (pageNum > this.pageRefs.length) {
            return null;
        }
        return this.pageRefs[pageNum - 1];
    }

    public byte[] getPageContent(int pageNum, RandomAccessFileOrArray file) throws IOException {
        PdfDictionary page = this.getPageN(pageNum);
        if (page == null) {
            return null;
        }
        PdfObject contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS));
        if (contents == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bout = null;
        if (contents.isStream()) {
            return PdfReader.getStreamBytes((PRStream)contents, file);
        }
        if (contents.isArray()) {
            PdfArray array = (PdfArray)contents;
            ArrayList list = array.getArrayList();
            bout = new ByteArrayOutputStream();
            int k = 0;
            while (k < list.size()) {
                PdfObject item = PdfReader.getPdfObject((PdfObject)list.get(k));
                if (item != null && item.isStream()) {
                    byte[] b = PdfReader.getStreamBytes((PRStream)item, file);
                    bout.write(b);
                    if (k != list.size() - 1) {
                        bout.write(10);
                    }
                }
                ++k;
            }
            return bout.toByteArray();
        }
        return new byte[0];
    }

    protected void killXref(PdfObject obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference && !obj.isIndirect()) {
            return;
        }
        switch (obj.type()) {
            case 10: {
                int xr = ((PRIndirectReference)obj).getNumber();
                obj = this.xrefObj[xr];
                this.xrefObj[xr] = null;
                this.freeXref = xr;
                this.killXref(obj);
                break;
            }
            case 5: {
                ArrayList t = ((PdfArray)obj).getArrayList();
                int i = 0;
                while (i < t.size()) {
                    this.killXref((PdfObject)t.get(i));
                    ++i;
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator i = dic.getKeys().iterator();
                while (i.hasNext()) {
                    this.killXref(dic.get((PdfName)i.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int pageNum, byte[] content) throws IOException {
        PdfDictionary page = this.getPageN(pageNum);
        if (page == null) {
            return;
        }
        PdfObject contents = page.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(contents);
        if (this.freeXref == -1) {
            int k = this.xrefObj.length - 1;
            while (k > 0) {
                if (this.xrefObj[k] == null) {
                    this.freeXref = k;
                    break;
                }
                --k;
            }
            if (this.freeXref == -1) {
                PdfObject[] temp = new PdfObject[this.xrefObj.length + 10];
                System.arraycopy(this.xrefObj, 0, temp, 0, this.xrefObj.length);
                this.freeXref = this.xrefObj.length;
                this.xrefObj = temp;
            }
        }
        page.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj[this.freeXref] = new PRStream(this, content);
    }

    public static byte[] getStreamBytes(PRStream stream, RandomAccessFileOrArray file) throws IOException {
        byte[] b;
        PdfReader reader = stream.getReader();
        PdfObject filter = PdfReader.getPdfObject(stream.get(PdfName.FILTER));
        if (stream.getOffset() < 0) {
            b = stream.getBytes();
        } else {
            b = new byte[stream.getLength()];
            file.seek(stream.getOffset());
            file.readFully(b);
            PdfEncryption decrypt = reader.getDecrypt();
            if (decrypt != null) {
                decrypt.setHashKey(stream.getObjNum(), stream.getObjGen());
                decrypt.prepareKey();
                decrypt.encryptRC4(b);
            }
        }
        ArrayList filters = new ArrayList();
        if (filter != null) {
            if (filter.isName()) {
                filters.add(filter);
            } else if (filter.isArray()) {
                filters = ((PdfArray)filter).getArrayList();
            }
        }
        int j = 0;
        while (j < filters.size()) {
            String name = ((PdfName)PdfReader.getPdfObject((PdfObject)filters.get(j))).toString();
            if (name.equals("/FlateDecode") || name.equals("/Fl")) {
                b = PdfReader.FlateDecode(b);
            } else if (name.equals("/ASCIIHexDecode") || name.equals("/AHx")) {
                b = PdfReader.ASCIIHexDecode(b);
            } else if (name.equals("/ASCII85Decode") || name.equals("/A85")) {
                b = PdfReader.ASCII85Decode(b);
            } else if (name.equals("/LZWDecode")) {
                b = PdfReader.LZWDecode(b);
            } else {
                throw new IOException("The filter " + name + " is not supported.");
            }
            ++j;
        }
        return b;
    }

    public void eliminateSharedStreams() {
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pages.length == 1) {
            return;
        }
        ArrayList<PRIndirectReference> newRefs = new ArrayList<PRIndirectReference>();
        ArrayList<PRStream> newStreams = new ArrayList<PRStream>();
        IntHashtable visited = new IntHashtable();
        int k = 0;
        while (k < this.pages.length) {
            PdfObject contents;
            PdfDictionary page = this.pages[k];
            if (page != null && (contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS))) != null) {
                if (contents.isStream()) {
                    PRIndirectReference ref = (PRIndirectReference)page.get(PdfName.CONTENTS);
                    if (visited.containsKey(ref.getNumber())) {
                        newRefs.add(ref);
                        newStreams.add(new PRStream((PRStream)contents, null));
                    } else {
                        visited.put(ref.getNumber(), 1);
                    }
                } else {
                    PdfArray array = (PdfArray)contents;
                    ArrayList list = array.getArrayList();
                    int j = 0;
                    while (j < list.size()) {
                        PRIndirectReference ref = (PRIndirectReference)list.get(j);
                        if (visited.containsKey(ref.getNumber())) {
                            newRefs.add(ref);
                            newStreams.add(new PRStream((PRStream)PdfReader.getPdfObject(ref), null));
                        } else {
                            visited.put(ref.getNumber(), 1);
                        }
                        ++j;
                    }
                }
            }
            ++k;
        }
        if (newStreams.size() == 0) {
            return;
        }
        int start = 1;
        int pass = 0;
        while (pass < 2) {
            int k2 = start;
            while (k2 < this.xrefObj.length) {
                if (this.xrefObj[k2] == null) {
                    int p = newStreams.size() - 1;
                    this.xrefObj[k2] = (PRStream)newStreams.get(p);
                    PRIndirectReference ref = (PRIndirectReference)newRefs.get(p);
                    ref.setNumber(k2, 0);
                    if (p == 0) {
                        return;
                    }
                    newStreams.remove(p);
                }
                ++k2;
            }
            start = this.xrefObj.length;
            PdfObject[] nxo = new PdfObject[this.xrefObj.length + newStreams.size()];
            System.arraycopy(this.xrefObj, 0, nxo, 0, this.xrefObj.length);
            this.xrefObj = nxo;
            ++pass;
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean tampered) {
        this.tampered = tampered;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getMetadata() throws IOException {
        PdfObject obj = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(obj instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray rf = this.getSafeFile();
        byte[] b = null;
        try {
            rf.reOpen();
            b = PdfReader.getStreamBytes((PRStream)obj, rf);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                rf.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception e) {
            return b;
        }
        rf.close();
        return b;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.length;
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] a1, byte[] a2) {
        int length = a2.length;
        int k = 0;
        while (k < length) {
            if (a1[k] != a2[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    static boolean existsName(PdfDictionary dic, PdfName key, PdfName value) {
        PdfObject type = PdfReader.getPdfObject(dic.get(key));
        if (type == null || !type.isName()) {
            return false;
        }
        PdfName name = (PdfName)type;
        return name.equals(value);
    }

    static String getFontName(PdfDictionary dic) {
        PdfObject type = PdfReader.getPdfObject(dic.get(PdfName.BASEFONT));
        if (type == null || !type.isName()) {
            return null;
        }
        return PdfName.decodeName(type.toString());
    }

    static String getSubsetPrefix(PdfDictionary dic) {
        String s = PdfReader.getFontName(dic);
        if (s == null) {
            return null;
        }
        if (s.length() < 8 || s.charAt(6) != '+') {
            return null;
        }
        int k = 0;
        while (k < 6) {
            char c = s.charAt(k);
            if (c < 'A' || c > 'Z') {
                return null;
            }
            ++k;
        }
        return s;
    }

    public int shuffleSubsetNames() {
        int total = 0;
        int k = 1;
        while (k < this.xrefObj.length) {
            PdfDictionary dic;
            PdfObject obj = this.xrefObj[k];
            if (obj != null && obj.isDictionary() && PdfReader.existsName(dic = (PdfDictionary)obj, PdfName.TYPE, PdfName.FONT)) {
                String s;
                if (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                    s = PdfReader.getSubsetPrefix(dic);
                    if (s != null) {
                        String ns = String.valueOf(BaseFont.createSubsetPrefix()) + s.substring(7);
                        PdfName newName = new PdfName(ns);
                        dic.put(PdfName.BASEFONT, newName);
                        ++total;
                        PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.FONTDESCRIPTOR));
                        if (fd != null) {
                            fd.put(PdfName.FONTNAME, newName);
                        }
                    }
                } else if (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE0)) {
                    PdfDictionary desc;
                    String sde;
                    ArrayList list;
                    s = PdfReader.getSubsetPrefix(dic);
                    PdfArray arr = (PdfArray)PdfReader.getPdfObject(dic.get(PdfName.DESCENDANTFONTS));
                    if (arr != null && (list = arr.getArrayList()).size() != 0 && (sde = PdfReader.getSubsetPrefix(desc = (PdfDictionary)PdfReader.getPdfObject((PdfObject)list.get(0)))) != null) {
                        String ns = BaseFont.createSubsetPrefix();
                        if (s != null) {
                            dic.put(PdfName.BASEFONT, new PdfName(String.valueOf(ns) + s.substring(7)));
                        }
                        PdfName newName = new PdfName(String.valueOf(ns) + sde.substring(7));
                        desc.put(PdfName.BASEFONT, newName);
                        ++total;
                        PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObject(desc.get(PdfName.FONTDESCRIPTOR));
                        if (fd != null) {
                            fd.put(PdfName.FONTNAME, newName);
                        }
                    }
                }
            }
            ++k;
        }
        return total;
    }

    public int createFakeFontSubsets() {
        int total = 0;
        int k = 1;
        while (k < this.xrefObj.length) {
            String s;
            PdfDictionary dic;
            PdfObject obj = this.xrefObj[k];
            if (obj != null && obj.isDictionary() && PdfReader.existsName(dic = (PdfDictionary)obj, PdfName.TYPE, PdfName.FONT) && (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TRUETYPE)) && (s = PdfReader.getSubsetPrefix(dic)) == null && (s = PdfReader.getFontName(dic)) != null) {
                String ns = String.valueOf(BaseFont.createSubsetPrefix()) + s;
                PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.FONTDESCRIPTOR));
                if (fd != null && (fd.get(PdfName.FONTFILE) != null || fd.get(PdfName.FONTFILE2) != null || fd.get(PdfName.FONTFILE3) != null)) {
                    PdfName newName = new PdfName(ns);
                    dic.put(PdfName.BASEFONT, newName);
                    fd.put(PdfName.FONTNAME, newName);
                    ++total;
                }
            }
            ++k;
        }
        return total;
    }

    private static PdfArray getNameArray(PdfObject obj) {
        PdfObject arr2;
        if (obj == null) {
            return null;
        }
        if ((obj = PdfReader.getPdfObject(obj)).isArray()) {
            return (PdfArray)obj;
        }
        if (obj.isDictionary() && (arr2 = PdfReader.getPdfObject(((PdfDictionary)obj).get(PdfName.D))) != null && arr2.isArray()) {
            return (PdfArray)arr2;
        }
        return null;
    }

    public HashMap getNamedDestination() {
        HashMap names = this.getNamedDestinationFromNames();
        names.putAll(this.getNamedDestinationFromStrings());
        return names;
    }

    public HashMap getNamedDestinationFromNames() {
        HashMap<String, PdfArray> names = new HashMap<String, PdfArray>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary dic = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.DESTS));
            Set keys = dic.getKeys();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                PdfName key = (PdfName)it.next();
                String name = PdfName.decodeName(key.toString());
                PdfArray arr = PdfReader.getNameArray(dic.get(key));
                if (arr == null) continue;
                names.put(name, arr);
            }
        }
        return names;
    }

    public HashMap getNamedDestinationFromStrings() {
        if (this.catalog.get(PdfName.NAMES) != null) {
            PdfDictionary dic = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.NAMES));
            if ((dic = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.DESTS))) != null) {
                HashMap names = PdfNameTree.readTree(dic);
                Iterator it = names.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    PdfArray arr = PdfReader.getNameArray((PdfObject)entry.getValue());
                    if (arr != null) {
                        entry.setValue(arr);
                        continue;
                    }
                    it.remove();
                }
                return names;
            }
        }
        return new HashMap();
    }

    private static void replaceNamedDestination(PdfObject obj, HashMap names) {
        if (obj != null && obj.isDictionary()) {
            PdfObject ob2 = PdfReader.getPdfObject(((PdfDictionary)obj).get(PdfName.DEST));
            String name = null;
            if (ob2 != null) {
                if (ob2.isName()) {
                    name = PdfName.decodeName(ob2.toString());
                } else if (ob2.isString()) {
                    name = ob2.toString();
                }
                PdfArray dest = (PdfArray)names.get(name);
                if (dest != null) {
                    ((PdfDictionary)obj).put(PdfName.DEST, dest);
                }
            } else {
                PdfDictionary dic;
                PdfName type;
                ob2 = PdfReader.getPdfObject(((PdfDictionary)obj).get(PdfName.A));
                if (ob2 != null && PdfName.GOTO.equals(type = (PdfName)PdfReader.getPdfObject((dic = (PdfDictionary)ob2).get(PdfName.S)))) {
                    ob2 = PdfReader.getPdfObject(dic.get(PdfName.D));
                    if (ob2.isName()) {
                        name = PdfName.decodeName(ob2.toString());
                    } else if (ob2.isString()) {
                        name = ob2.toString();
                    }
                    PdfArray dest = (PdfArray)names.get(name);
                    if (dest != null) {
                        dic.put(PdfName.D, dest);
                    }
                }
            }
        }
    }

    public void removeFields() {
        int k = 0;
        while (k < this.pages.length) {
            PdfDictionary page = this.pages[k];
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
            if (annots != null) {
                ArrayList arr = annots.getArrayList();
                int j = 0;
                while (j < arr.size()) {
                    PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arr.get(j));
                    if (PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) {
                        arr.remove(j--);
                    }
                    ++j;
                }
                if (arr.isEmpty()) {
                    page.remove(PdfName.ANNOTS);
                }
            }
            ++k;
        }
        this.catalog.remove(PdfName.ACROFORM);
    }

    public void removeAnnotations() {
        int k = 0;
        while (k < this.pages.length) {
            this.pages[k].remove(PdfName.ANNOTS);
            ++k;
        }
        this.catalog.remove(PdfName.ACROFORM);
    }

    private void iterateBookmarks(PdfDictionary outline, HashMap names) {
        while (outline != null) {
            PdfReader.replaceNamedDestination(outline, names);
            PdfDictionary first = (PdfDictionary)PdfReader.getPdfObject(outline.get(PdfName.FIRST));
            if (first != null) {
                this.iterateBookmarks(first, names);
            }
            outline = (PdfDictionary)PdfReader.getPdfObject(outline.get(PdfName.NEXT));
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap names = this.getNamedDestination();
        if (names.size() == 0) {
            return;
        }
        int k = 0;
        while (k < this.pages.length) {
            PdfArray arr = (PdfArray)PdfReader.getPdfObject(this.pages[k].get(PdfName.ANNOTS));
            if (arr != null) {
                ArrayList list = arr.getArrayList();
                int an = 0;
                while (an < list.size()) {
                    PdfObject obj = PdfReader.getPdfObject((PdfObject)list.get(an));
                    PdfReader.replaceNamedDestination(obj, names);
                    ++an;
                }
            }
            ++k;
        }
        PdfDictionary outlines = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.OUTLINES));
        if (outlines == null) {
            return;
        }
        this.iterateBookmarks((PdfDictionary)PdfReader.getPdfObject(outlines.get(PdfName.FIRST)), names);
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary original, PdfDictionary copy, PdfReader newReader) {
        if (copy == null) {
            copy = new PdfDictionary();
        }
        Iterator it = original.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            copy.put(key, PdfReader.duplicatePdfObject(original.get(key), newReader));
        }
        return copy;
    }

    protected static PdfObject duplicatePdfObject(PdfObject original, PdfReader newReader) {
        if (original == null) {
            return null;
        }
        switch (original.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)original, null, newReader);
            }
            case 7: {
                PRStream org = (PRStream)original;
                PRStream stream = new PRStream(org, null, newReader);
                PdfReader.duplicatePdfDictionary(org, stream, newReader);
                return stream;
            }
            case 5: {
                ArrayList list = ((PdfArray)original).getArrayList();
                PdfArray arr = new PdfArray();
                Iterator it = ((AbstractList)list).iterator();
                while (it.hasNext()) {
                    arr.add(PdfReader.duplicatePdfObject((PdfObject)it.next(), newReader));
                }
                return arr;
            }
            case 10: {
                PRIndirectReference org = (PRIndirectReference)original;
                return new PRIndirectReference(newReader, org.getNumber(), org.getGeneration());
            }
        }
        return original;
    }

    protected void removeUnusedNode(PdfObject obj, boolean[] hits) {
        if (obj == null) {
            return;
        }
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    PdfName key = (PdfName)it.next();
                    this.removeUnusedNode(dic.get(key), hits);
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                PdfArray arr = new PdfArray();
                Iterator it = ((AbstractList)list).iterator();
                while (it.hasNext()) {
                    this.removeUnusedNode((PdfObject)it.next(), hits);
                }
                break;
            }
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)obj;
                int num = ref.getNumber();
                if (hits[num]) break;
                hits[num] = true;
                this.removeUnusedNode(PdfReader.getPdfObject(ref), hits);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] hits = new boolean[this.xrefObj.length];
        this.removeUnusedNode(this.trailer, hits);
        int total = 0;
        int k = 1;
        while (k < hits.length) {
            if (!hits[k] && this.xrefObj[k] != null) {
                this.xrefObj[k] = null;
                ++total;
            }
            ++k;
        }
        return total;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }
}

