/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfField;
import com.lowagie.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOCEntry
extends Chunk
implements RtfField {
    private boolean hideText = false;
    private boolean hidePageNumber = false;
    private String entryName;
    private Font entryFont;
    private Font contentFont;

    public RtfTOCEntry(String content, Font contentFont) {
        this(content, contentFont, content, contentFont);
    }

    public RtfTOCEntry(String content, Font contentFont, String entryName, Font entryFont) {
        super(content, contentFont);
        this.entryName = entryName;
        this.entryFont = entryFont;
        this.contentFont = contentFont;
    }

    public void write(RtfWriter writer, OutputStream out) throws IOException {
        if (!this.hideText) {
            writer.writeInitialFontSignature(out, new Chunk("", this.contentFont));
            out.write(RtfWriter.filterSpecialChar(this.content()).getBytes());
            writer.writeFinishingFontSignature(out, new Chunk("", this.contentFont));
        }
        if (!this.entryFont.equals(this.contentFont)) {
            writer.writeInitialFontSignature(out, new Chunk("", this.entryFont));
            this.writeField(out);
            writer.writeFinishingFontSignature(out, new Chunk("", this.entryFont));
        } else {
            writer.writeInitialFontSignature(out, new Chunk("", this.contentFont));
            this.writeField(out);
            writer.writeFinishingFontSignature(out, new Chunk("", this.contentFont));
        }
    }

    private void writeField(OutputStream out) throws IOException {
        out.write(123);
        out.write(92);
        out.write("v".getBytes());
        out.write(123);
        out.write(92);
        if (!this.hidePageNumber) {
            out.write("tc".getBytes());
        } else {
            out.write("tcn".getBytes());
        }
        out.write(32);
        out.write(RtfWriter.filterSpecialChar(this.entryName).getBytes());
        out.write(32);
        out.write(125);
        out.write(125);
    }

    public void hideText() {
        this.hideText = true;
    }

    public void hidePageNumber() {
        this.hidePageNumber = true;
    }
}

