/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.image;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import net.sf.sqs_xml.image.PBMRasterFactory;
import org.apache.batik.ext.awt.image.codec.FileCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.ImageDecodeParam;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;

public class RasterFactory {
    public static final String TIF = ".tif";
    public static final String TIFF = ".tiff";
    public static final String PNG = ".png";
    public static final String PBM = ".pbm";
    public static final String PPM = ".ppm";
    public static final String GIF = ".gif";
    public static final String ERROR_NOT_PNM = "data format may not be PNM";
    public static final int[] BLACK = new int[3];
    public static final int[] WHITE = new int[]{255, 255, 255};

    public static boolean isSupported(String filename) {
        return RasterFactory.isTiff(filename) || RasterFactory.isPNG(filename) || RasterFactory.isGIF(filename);
    }

    public static boolean isTiff(String filename) {
        return filename.toLowerCase().endsWith(TIF) || filename.toLowerCase().endsWith(TIFF);
    }

    public static boolean isPNG(String filename) {
        return filename.toLowerCase().endsWith(PNG);
    }

    public static boolean isPBM(String filename) {
        return filename.toLowerCase().endsWith(PBM);
    }

    public static boolean isPPM(String filename) {
        return filename.toLowerCase().endsWith(PPM);
    }

    public static boolean isGIF(String filename) {
        return filename.toLowerCase().endsWith(GIF);
    }

    public static Raster create(String filename) throws IOException {
        return RasterFactory.create(new File(filename));
    }

    public static BufferedImage createImage(File file) throws IOException {
        if (RasterFactory.isTiff(file.getName())) {
            FileCacheSeekableStream stream = new FileCacheSeekableStream((InputStream)new FileInputStream(file));
            TIFFImageDecoder decoder = new TIFFImageDecoder((SeekableStream)stream, (ImageDecodeParam)new TIFFDecodeParam());
            RenderedImage renderedImage = decoder.decodeAsRenderedImage();
            BufferedImage image = new BufferedImage(renderedImage.getColorModel(), renderedImage.getData().createCompatibleWritableRaster(), true, new Hashtable());
            image.setData(renderedImage.getData());
            stream.close();
            return image;
        }
        if (RasterFactory.isPBM(file.getName())) {
            FileInputStream stream = new FileInputStream(file);
            BufferedImage image = RasterFactory.createByPBM(stream);
            stream.close();
            return image;
        }
        return ImageIO.read(file);
    }

    public static Raster create(File file) throws IOException {
        if (RasterFactory.isTiff(file.getName())) {
            FileCacheSeekableStream stream = new FileCacheSeekableStream((InputStream)new FileInputStream(file));
            TIFFImageDecoder decoder = new TIFFImageDecoder((SeekableStream)stream, (ImageDecodeParam)new TIFFDecodeParam());
            Raster raster = decoder.decodeAsRaster();
            stream.close();
            return raster;
        }
        if (RasterFactory.isPBM(file.getName())) {
            FileInputStream stream = new FileInputStream(file);
            Raster raster = RasterFactory.createByPBM(stream).getData();
            stream.close();
            return raster;
        }
        Raster raster = ImageIO.read(file).getData();
        return raster;
    }

    public static BufferedImage createByPBM(InputStream in) throws IOException, IllegalArgumentException {
        return new PBMRasterFactory(in).createByPBM();
    }
}

