/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.reader.logic.CellValueOption;
import net.sf.sqs_xml.reader.logic.FileFunctions;
import net.sf.sqs_xml.reader.logic.QuestionnaireSchema;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;

public class ReaderResultBuilder {
    public static final int ALL_MODE = 0;
    public static final int TEXTAREA_MODE = 1;
    public static final int MARK_MODE = 2;
    protected Object[] matrix = null;
    protected List rowFileList = new LinkedList();
    private Map areaImageMap = new HashMap();
    Map cellIDToAreaFileMap = new HashMap();
    protected QuestionnaireSchema schema;
    private List currentRowFileList;

    public void setQuestionnaireSchema(QuestionnaireSchema schema) {
        this.schema = schema;
    }

    public void setRowSize(int size) {
        this.matrix = new Object[size];
    }

    public void addRowFileList(List rowFileList) {
        this.rowFileList.add(rowFileList);
        this.currentRowFileList = rowFileList;
    }

    public void addRowFile(File rowFile) {
        this.currentRowFileList.add(rowFile);
    }

    public void setMatrix(int index, Object[] line) {
        this.matrix[index] = line;
    }

    public List getColumnNames() {
        return this.schema.columnNames;
    }

    public int getPage(String id) {
        try {
            return this.schema.getPage(id);
        }
        catch (TransformerException ex) {
            return -1;
        }
    }

    public void putAreaFile(int rowId, String id, File areaFile) {
        this.cellIDToAreaFileMap.put(new CellID(rowId, id), areaFile);
    }

    public File getAreaFile(int rowId, String id) {
        return (File)this.cellIDToAreaFileMap.get(new CellID(rowId, id));
    }

    public void addAreaImage(int rowIndex, String qid, File file) {
        this.areaImageMap.put(String.valueOf(rowIndex) + "\t" + qid, file);
    }

    public void saveCSV(File tgtfile, String encoding) throws TransformerException, IOException {
        PrintWriter out = FileUtil.createPrintWriter(tgtfile, encoding);
        this.saveCSVHeader(out);
        this.saveCVSBody(out);
        out.close();
    }

    public void saveHTML(File tgtfile, String encoding, File imagedir, File resultdir, int mode) throws TransformerException, IOException {
        PrintWriter out = FileUtil.createPrintWriter(tgtfile, encoding);
        this.saveHTML(out, encoding, imagedir, resultdir, tgtfile, mode);
        out.close();
    }

    private void saveCVSBody(PrintWriter out) {
        int j = 0;
        while (j < this.matrix.length) {
            out.print(j + 1);
            out.print("\t");
            out.print(((List)this.rowFileList.get(j)).get(0));
            Object[] line = (Object[])this.matrix[j];
            this.saveCSVRow(out, j, line);
            out.println();
            ++j;
        }
    }

    private void saveCSVRow(PrintWriter out, int rowID, Object[] line) {
        int columnID = 0;
        while (columnID < line.length) {
            out.print("\t");
            List columnNameList = this.getColumnNames();
            if (line[columnID] != null) {
                String value = null;
                if (line[columnID] instanceof String) {
                    value = (String)line[columnID];
                } else if (line[columnID] instanceof CellValueOption) {
                    value = ((CellValueOption)line[columnID]).value;
                }
                String id = (String)columnNameList.get(columnID);
                File areaImageFile = (File)this.areaImageMap.get(String.valueOf(rowID) + "\t" + id);
                if (areaImageFile != null && areaImageFile.getName().endsWith("-MarkError.png")) {
                    out.print("?");
                } else {
                    out.print(StringUtil.escape(value));
                }
            }
            ++columnID;
        }
    }

    private void saveHTML(PrintWriter out, String encoding, File imagedir, File resultdir, File targetFile, int mode) throws TransformerException {
        try {
            out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ja\" lang=\"ja\" version=\"1.1\">");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\" />");
            out.print("<title>");
            out.print(targetFile.getAbsolutePath());
            out.println("</title>");
            out.println("<style type=\"text/css\">table, th, td{border-style: solid; border-width: 1px; border-color: black;} tr.page{background-color:#bbf}tr.qid{background-color:#fbb} th.id{background-color:#bfb} img{border-width:0} body{background-color: #ddd; padding: 0.5em} textarea{background-color:#fff}</style></head>");
            out.println("<body>");
            out.println("<h1>" + targetFile.getAbsolutePath() + "</h1>");
            out.print("<table>");
            out.println("<thead>");
            out.print("<tr class=\"page\"><th rowspan=\"2\">sampleID</th>");
            out.print("<th rowspan=\"2\">file</th>");
            out.println();
            this.saveHTMLTableHeader1(out, imagedir, mode);
            out.print("</tr>");
            out.print("<tr class=\"qid\">");
            this.saveHTMLTableHeader2(out, mode);
            out.print("</tr>");
            out.println("</thead><tbody>");
            this.saveHTMLRows(out, imagedir, mode);
            out.print("</tbody>");
            out.println("</table>");
            out.println("</body></html>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveHTMLRows(PrintWriter out, File imagedir, int mode) {
        int rowID = 0;
        while (rowID < this.matrix.length) {
            out.print("<tr>");
            out.print("<th class=\"id\">");
            out.print(rowID + 1);
            out.print("</th>");
            out.print("<th class=\"id\">");
            List rowFiles = (List)this.rowFileList.get(rowID);
            int i = 0;
            while (i < rowFiles.size()) {
                if (i > 0) {
                    out.print(", ");
                }
                File file = (File)rowFiles.get(i);
                out.print("<a href=\"../" + FileFunctions.getRelativePath(imagedir, file) + "\" title=\"" + file.getAbsolutePath() + "\">");
                out.print(i + 1);
                out.print("</a>");
                ++i;
            }
            out.print("</th>");
            this.saveHTMLRowColumns(out, imagedir, mode, rowID);
            out.print("</tr>");
            out.println();
            ++rowID;
        }
    }

    private void saveHTMLTableHeader1(PrintWriter out, File imagedir, int mode) throws TransformerException {
        int prevPage = -1;
        boolean colspan = false;
        int columnID = 0;
        while (columnID < this.getColumnNames().size()) {
            String id = (String)this.getColumnNames().get(columnID);
            if (mode != 1 || this.getAreaFile(0, id) != null) {
                String columnName = (String)this.getColumnNames().get(columnID);
                int page = this.getPage(columnName);
                out.print("<th colspan=\"1\">");
                File file = (File)((List)this.rowFileList.get(0)).get(page - 1);
                out.print("<a href=\"../" + FileFunctions.getRelativePath(imagedir, file) + "\">P." + page + "</a>");
                out.println("</th>");
            }
            ++columnID;
        }
    }

    private void saveHTMLTableHeader2(PrintWriter out, int mode) throws TransformerException {
        int columnID = 0;
        while (columnID < this.getColumnNames().size()) {
            String id = (String)this.getColumnNames().get(columnID);
            if (mode != 1 || this.getAreaFile(0, id) != null) {
                String columnName = (String)this.getColumnNames().get(columnID);
                out.print("<th>");
                out.print(StringUtil.replaceAll(columnName, "/", "/<br/>"));
                out.println("</th>");
            }
            ++columnID;
        }
    }

    private void saveHTMLRowColumns(PrintWriter out, File imagedir, int mode, int rowID) {
        Object[] line = (Object[])this.matrix[rowID];
        int columnID = 0;
        while (columnID < line.length) {
            String id = (String)this.getColumnNames().get(columnID);
            File imagefile = this.getAreaFile(rowID, id);
            if (mode != 1 || imagefile != null) {
                File areaImageFile = (File)this.areaImageMap.get(String.valueOf(rowID) + "\t" + id);
                if (areaImageFile != null && areaImageFile.getName().endsWith("-MarkError.png")) {
                    out.print("<td style=\"background-color: #faf;\">");
                    out.print("<a href=\"ERROR/" + areaImageFile.getName() + "\">?</a>");
                    out.print("</td>");
                } else {
                    out.print("<td>");
                    String value = null;
                    if (line[columnID] != null) {
                        value = line[columnID] instanceof String ? (String)line[columnID] : (line[columnID] instanceof CellValueOption ? ((CellValueOption)line[columnID]).value : line[columnID].getClass().getName());
                    }
                    if ((mode == 1 || mode == 0) && imagefile != null) {
                        out.print("<a href=\"../" + FileFunctions.getRelativePath(imagedir, areaImageFile) + "\" title=\"" + (rowID + 1) + "-" + id + "\" tabindex=\"" + columnID + "\">");
                        out.print("<img src=\"TEXTAREA/" + imagefile.getName() + "\" alt=\"" + (rowID + 1) + "-" + id + "\"/>");
                        out.print("</a>");
                    }
                    if (value != null) {
                        out.print(StringUtil.escapeHTML(value));
                    } else {
                        out.print(" ");
                    }
                    out.print("</td>");
                }
            }
            ++columnID;
        }
    }

    private void saveCSVHeader(PrintWriter out) throws TransformerException {
        List columnNames = this.getColumnNames();
        out.print("sampleID");
        out.print("\t");
        out.print("file");
        int i = 0;
        while (i < columnNames.size()) {
            out.print("\t");
            String id = (String)columnNames.get(i);
            out.print(id);
            ++i;
        }
        out.println();
    }

    class CellID {
        int rowId;
        String id;

        CellID(int rowId, String id) {
            this.rowId = rowId;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == null && !(o instanceof CellID)) {
                return false;
            }
            CellID c = (CellID)o;
            return c.rowId == this.rowId && c.id.equals(this.id);
        }

        public int hashCode() {
            return this.rowId + this.id.hashCode();
        }
    }
}

