/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.swing.FileDropAcceptableTextField;

public abstract class FileChooserPanel
extends JPanel {
    protected FileDropAcceptableTextField fileDropAcceptableTextField = this.createFileDropAcceptableTextField();
    protected JButton fileOpenButton;
    SuffixBasedFileChooser openFileChooser;

    public FileChooserPanel(JFrame frame, String borderTitle, String inputFileLabel, SuffixBasedFileChooser openFileChooser) {
        this.fileOpenButton = this.createFileOpenButton(frame);
        this.setBorder(BorderFactory.createTitledBorder(borderTitle));
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(inputFileLabel));
        this.add(this.fileDropAcceptableTextField);
        this.add(new JLabel(" / "));
        this.add(this.fileOpenButton);
        this.openFileChooser = openFileChooser;
        File defaultFile = openFileChooser.getSelectedFile();
        if (defaultFile != null) {
            this.fileDropAcceptableTextField.setText(defaultFile.getAbsolutePath());
        }
    }

    private JButton createFileOpenButton(final JFrame frame) {
        JButton fileOpenButton = new JButton("\u9078\u629e\u2026");
        fileOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int result = FileChooserPanel.this.openFileChooser.showOpenDialog(frame);
                if (result == 0) {
                    File file = FileChooserPanel.this.openFileChooser.getSelectedFile();
                    FileChooserPanel.this.setSelectedFile(file);
                    FileChooserPanel.this.fireFileSelection(file);
                }
            }
        });
        return fileOpenButton;
    }

    private FileDropAcceptableTextField createFileDropAcceptableTextField() {
        FileDropAcceptableTextField fileDropAcceptableTextField = new FileDropAcceptableTextField(){

            public void drop(File file) {
                FileChooserPanel.this.fireFileSelection(file);
            }
        };
        fileDropAcceptableTextField.setColumns(20);
        new DropTarget(fileDropAcceptableTextField, 3, fileDropAcceptableTextField, true);
        return fileDropAcceptableTextField;
    }

    public JButton getFileOpenButton() {
        return this.fileOpenButton;
    }

    public FileDropAcceptableTextField getFileDropAcceptableTextField() {
        return this.fileDropAcceptableTextField;
    }

    public String getAbsolutePath() {
        return this.fileDropAcceptableTextField.getText();
    }

    public void setSelectedFile(File file) {
        this.openFileChooser.setSelectedFile(file);
        this.fileDropAcceptableTextField.setText(file.getAbsolutePath());
    }

    public void setEnabled(boolean isEnabled) {
        this.fileDropAcceptableTextField.setEnabled(isEnabled);
        this.fileOpenButton.setEnabled(isEnabled);
    }

    public abstract void fireFileSelection(File var1);
}

