/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import java.security.MessageDigest;

public class PdfEncryption {
    static final byte[] pad;
    byte[] state = new byte[256];
    int x;
    int y;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    int permissions;
    byte[] documentID;
    static long seq;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        pad = byArray;
        seq = System.currentTimeMillis();
    }

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private byte[] padPassword(byte[] userPassword) {
        byte[] userPad = new byte[32];
        if (userPassword == null) {
            System.arraycopy(pad, 0, userPad, 0, 32);
        } else {
            System.arraycopy(userPassword, 0, userPad, 0, Math.min(userPassword.length, 32));
            if (userPassword.length < 32) {
                System.arraycopy(pad, 0, userPad, userPassword.length, 32 - userPassword.length);
            }
        }
        return userPad;
    }

    private byte[] computeOwnerKey(byte[] userPad, byte[] ownerPad, boolean strength128Bits) {
        byte[] ownerKey = new byte[32];
        byte[] digest = this.md5.digest(ownerPad);
        if (strength128Bits) {
            byte[] mkey = new byte[16];
            int k = 0;
            while (k < 50) {
                digest = this.md5.digest(digest);
                ++k;
            }
            System.arraycopy(userPad, 0, ownerKey, 0, 32);
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < mkey.length) {
                    mkey[j] = (byte)(digest[j] ^ i);
                    ++j;
                }
                this.prepareRC4Key(mkey);
                this.encryptRC4(ownerKey);
                ++i;
            }
        } else {
            this.prepareRC4Key(digest, 0, 5);
            this.encryptRC4(userPad, ownerKey);
        }
        return ownerKey;
    }

    private void setupGlobalEncryptionKey(byte[] documentID, byte[] userPad, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.documentID = documentID;
        this.ownerKey = ownerKey;
        this.permissions = permissions;
        this.mkey = new byte[strength128Bits ? 16 : 5];
        this.md5.reset();
        this.md5.update(userPad);
        this.md5.update(ownerKey);
        byte[] ext = new byte[]{(byte)permissions, (byte)(permissions >> 8), (byte)(permissions >> 16), (byte)(permissions >> 24)};
        this.md5.update(ext, 0, 4);
        if (documentID != null) {
            this.md5.update(documentID);
        }
        byte[] digest = this.md5.digest();
        if (this.mkey.length == 16) {
            int k = 0;
            while (k < 50) {
                digest = this.md5.digest(digest);
                ++k;
            }
        }
        System.arraycopy(digest, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey() {
        if (this.mkey.length == 16) {
            this.md5.update(pad);
            byte[] digest = this.md5.digest(this.documentID);
            System.arraycopy(digest, 0, this.userKey, 0, 16);
            int k = 16;
            while (k < 32) {
                this.userKey[k] = 0;
                ++k;
            }
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < this.mkey.length) {
                    digest[j] = (byte)(this.mkey[j] ^ i);
                    ++j;
                }
                this.prepareRC4Key(digest, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
                ++i;
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) {
        if (ownerPassword == null || ownerPassword.length == 0) {
            ownerPassword = this.md5.digest(PdfEncryption.createDocumentId());
        }
        permissions |= strength128Bits ? -3904 : -64;
        byte[] userPad = this.padPassword(userPassword);
        byte[] ownerPad = this.padPassword(ownerPassword);
        this.ownerKey = this.computeOwnerKey(userPad, ownerPad, strength128Bits);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, userPad, this.ownerKey, permissions &= 0xFFFFFFFC, strength128Bits);
    }

    public static byte[] createDocumentId() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        long time = System.currentTimeMillis();
        long mem = Runtime.getRuntime().freeMemory();
        String s = String.valueOf(time) + "+" + mem + "+" + seq++;
        return md5.digest(s.getBytes());
    }

    public void setupByUserPassword(byte[] documentID, byte[] userPassword, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.setupByUserPad(documentID, this.padPassword(userPassword), ownerKey, permissions, strength128Bits);
    }

    private void setupByUserPad(byte[] documentID, byte[] userPad, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.setupGlobalEncryptionKey(documentID, userPad, ownerKey, permissions, strength128Bits);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] documentID, byte[] ownerPassword, byte[] userKey, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.setupByOwnerPad(documentID, this.padPassword(ownerPassword), userKey, ownerKey, permissions, strength128Bits);
    }

    private void setupByOwnerPad(byte[] documentID, byte[] ownerPad, byte[] userKey, byte[] ownerKey, int permissions, boolean strength128Bits) {
        byte[] userPad = this.computeOwnerKey(ownerKey, ownerPad, strength128Bits);
        this.setupGlobalEncryptionKey(documentID, userPad, ownerKey, permissions, strength128Bits);
        this.setupUserKey();
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void setHashKey(int number, int generation) {
        this.md5.reset();
        this.extra[0] = (byte)number;
        this.extra[1] = (byte)(number >> 8);
        this.extra[2] = (byte)(number >> 16);
        this.extra[3] = (byte)generation;
        this.extra[4] = (byte)(generation >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] id) {
        ByteBuffer buf = new ByteBuffer(90);
        buf.append('[').append('<');
        int k = 0;
        while (k < 16) {
            buf.appendHex(id[k]);
            ++k;
        }
        buf.append('>').append('<');
        k = 0;
        while (k < 16) {
            buf.appendHex(id[k]);
            ++k;
        }
        buf.append('>').append(']');
        return new PdfLiteral(buf.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.FILTER, PdfName.STANDARD);
        dic.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        dic.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        dic.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            dic.put(PdfName.V, new PdfNumber(2));
            dic.put(PdfName.R, new PdfNumber(3));
            dic.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            dic.put(PdfName.V, new PdfNumber(1));
            dic.put(PdfName.R, new PdfNumber(2));
        }
        return dic;
    }

    public void prepareRC4Key(byte[] key) {
        this.prepareRC4Key(key, 0, key.length);
    }

    public void prepareRC4Key(byte[] key, int off, int len) {
        int index1 = 0;
        int index2 = 0;
        int k = 0;
        while (k < 256) {
            this.state[k] = (byte)k;
            ++k;
        }
        this.x = 0;
        this.y = 0;
        int k2 = 0;
        while (k2 < 256) {
            index2 = key[index1 + off] + this.state[k2] + index2 & 0xFF;
            byte tmp = this.state[k2];
            this.state[k2] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % len;
            ++k2;
        }
    }

    public void encryptRC4(byte[] dataIn, int off, int len, byte[] dataOut) {
        int length = len + off;
        int k = off;
        while (k < length) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            dataOut[k] = (byte)(dataIn[k] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++k;
        }
    }

    public void encryptRC4(byte[] data, int off, int len) {
        this.encryptRC4(data, off, len, data);
    }

    public void encryptRC4(byte[] dataIn, byte[] dataOut) {
        this.encryptRC4(dataIn, 0, dataIn.length, dataOut);
    }

    public void encryptRC4(byte[] data) {
        this.encryptRC4(data, 0, data.length, data);
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }
}

