/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    protected boolean compressed = false;
    protected ByteArrayOutputStream streamBytes = null;
    static final byte[] STARTSTREAM = DocWriter.getISOBytes("\nstream\n");
    static final byte[] ENDSTREAM = DocWriter.getISOBytes("\nendstream");
    static final int SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;

    public PdfStream(byte[] bytes) {
        this.type = 7;
        this.bytes = bytes;
        this.put(PdfName.LENGTH, new PdfNumber(bytes.length));
    }

    protected PdfStream() {
        this.type = 7;
    }

    public void flateCompress() throws PdfException {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        PdfObject filter = this.get(PdfName.FILTER);
        if (filter != null) {
            if (filter.isName() && ((PdfName)filter).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (filter.isArray() && ((PdfArray)filter).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new PdfException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DeflaterOutputStream zip = new DeflaterOutputStream(stream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(zip);
            } else {
                zip.write(this.bytes);
            }
            zip.close();
            this.streamBytes = stream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (filter == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray filters = new PdfArray(filter);
                filters.add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, filters);
            }
            this.compressed = true;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    protected void superToPdf(PdfWriter writer, OutputStream os) throws IOException {
        super.toPdf(writer, os);
    }

    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        this.superToPdf(writer, os);
        os.write(STARTSTREAM);
        PdfEncryption crypto = null;
        if (writer != null) {
            crypto = writer.getEncryption();
        }
        if (crypto == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(os);
            } else {
                os.write(this.bytes);
            }
        } else {
            byte[] b;
            crypto.prepareKey();
            if (this.streamBytes != null) {
                b = this.streamBytes.toByteArray();
                crypto.encryptRC4(b);
            } else {
                b = new byte[this.bytes.length];
                crypto.encryptRC4(this.bytes, b);
            }
            os.write(b);
        }
        os.write(ENDSTREAM);
    }
}

